/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import org.apache.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;

public final class BatchAppenderators {
    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates) {
        return BatchAppenderators.newAppenderator(taskId, appenderatorsManager, metrics, toolbox, dataSchema, appenderatorConfig, toolbox.getSegmentPusher(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates);
    }

    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, DataSegmentPusher segmentPusher, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates) {
        if (toolbox.getConfig().getBatchProcessingMode() == TaskConfig.BatchProcessingMode.OPEN_SEGMENTS) {
            return appenderatorsManager.createOpenSegmentsOfflineAppenderatorForTask(taskId, dataSchema, appenderatorConfig.withBasePersistDirectory(toolbox.getPersistDir()), metrics, segmentPusher, toolbox.getJsonMapper(), toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates);
        }
        if (toolbox.getConfig().getBatchProcessingMode() == TaskConfig.BatchProcessingMode.CLOSED_SEGMENTS) {
            return appenderatorsManager.createClosedSegmentsOfflineAppenderatorForTask(taskId, dataSchema, appenderatorConfig.withBasePersistDirectory(toolbox.getPersistDir()), metrics, segmentPusher, toolbox.getJsonMapper(), toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates);
        }
        if (toolbox.getConfig().getBatchProcessingMode() == TaskConfig.BatchProcessingMode.CLOSED_SEGMENTS_SINKS) {
            return appenderatorsManager.createOfflineAppenderatorForTask(taskId, dataSchema, appenderatorConfig.withBasePersistDirectory(toolbox.getPersistDir()), metrics, segmentPusher, toolbox.getJsonMapper(), toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates);
        }
        throw new IAE("Invalid batchProcesingMode[%s]", new Object[]{toolbox.getConfig().getBatchProcessingMode()});
    }

    public static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller());
    }

    private BatchAppenderators() {
    }
}

