/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskAuditLogConfig;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class LocalTaskActionClient
implements TaskActionClient {
    private static final EmittingLogger log = new EmittingLogger(LocalTaskActionClient.class);
    private final Task task;
    private final TaskStorage storage;
    private final TaskActionToolbox toolbox;
    private final TaskAuditLogConfig auditLogConfig;

    public LocalTaskActionClient(Task task, TaskStorage storage, TaskActionToolbox toolbox, TaskAuditLogConfig auditLogConfig) {
        this.task = task;
        this.storage = storage;
        this.toolbox = toolbox;
        this.auditLogConfig = auditLogConfig;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) {
        log.debug("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        if (this.auditLogConfig.isEnabled() && taskAction.isAudited()) {
            try {
                long auditLogStartTime = System.currentTimeMillis();
                this.storage.addAuditLog(this.task, taskAction);
                this.emitTimerMetric("task/action/log/time", taskAction, System.currentTimeMillis() - auditLogStartTime);
            }
            catch (Exception e) {
                String actionClass = taskAction.getClass().getName();
                log.makeAlert((Throwable)e, "Failed to record action in audit log", new Object[0]).addData("task", (Object)this.task.getId()).addData("actionClass", (Object)actionClass).emit();
                throw new ISE((Throwable)e, "Failed to record action [%s] in audit log", new Object[]{actionClass});
            }
        }
        long performStartTime = System.currentTimeMillis();
        RetType result = this.performAction(taskAction);
        this.emitTimerMetric("task/action/run/time", taskAction, System.currentTimeMillis() - performStartTime);
        return result;
    }

    private <R> R performAction(TaskAction<R> taskAction) {
        try {
            R result = taskAction.canPerformAsync(this.task, this.toolbox) ? taskAction.performAsync(this.task, this.toolbox).get(5L, TimeUnit.MINUTES) : taskAction.perform(this.task, this.toolbox);
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void emitTimerMetric(String metric, TaskAction<?> action, long time) {
        ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, this.task);
        String actionType = LocalTaskActionClient.getActionType(this.toolbox.getJsonMapper(), action);
        if (actionType != null) {
            metricBuilder.setDimension("taskActionType", (Object)actionType);
        }
        this.toolbox.getEmitter().emit(metricBuilder.build(metric, (Number)Math.max(0L, time)));
    }

    @Nullable
    static String getActionType(ObjectMapper jsonMapper, TaskAction<?> action) {
        try {
            Map m = (Map)jsonMapper.convertValue(action, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object typeObject = m.get("type");
            if (typeObject instanceof String) {
                return (String)typeObject;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

