/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.apache.druid.timeline.DataSegment;

public class TaskToolbox {
    private final TaskConfig config;
    private final DruidNode taskExecutorNode;
    private final TaskActionClient taskActionClient;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    @Nullable
    private final Provider<MonitorScheduler> monitorSchedulerProvider;
    private final QueryProcessingPool queryProcessingPool;
    private final JoinableFactory joinableFactory;
    private final SegmentCacheManager segmentCacheManager;
    private final ObjectMapper jsonMapper;
    private final File taskWorkDir;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9 indexMergerV9;
    private final TaskReportFileWriter taskReportFileWriter;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;
    private final AuthorizerMapper authorizerMapper;
    private final ChatHandlerProvider chatHandlerProvider;
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final AppenderatorsManager appenderatorsManager;
    private final OverlordClient overlordClient;
    private final CoordinatorClient coordinatorClient;
    private final IntermediaryDataManager intermediaryDataManager;
    private final ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider;
    private final ShuffleClient shuffleClient;
    private final TaskLogPusher taskLogPusher;
    private final String attemptId;

    public TaskToolbox(TaskConfig config, DruidNode taskExecutorNode, TaskActionClient taskActionClient, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, QueryProcessingPool queryProcessingPool, JoinableFactory joinableFactory, @Nullable Provider<MonitorScheduler> monitorSchedulerProvider, SegmentCacheManager segmentCacheManager, ObjectMapper jsonMapper, File taskWorkDir, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter, IntermediaryDataManager intermediaryDataManager, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, AppenderatorsManager appenderatorsManager, OverlordClient overlordClient, CoordinatorClient coordinatorClient, ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider, ShuffleClient shuffleClient, TaskLogPusher taskLogPusher, String attemptId) {
        this.config = config;
        this.taskExecutorNode = taskExecutorNode;
        this.taskActionClient = taskActionClient;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryProcessingPool = queryProcessingPool;
        this.joinableFactory = joinableFactory;
        this.monitorSchedulerProvider = monitorSchedulerProvider;
        this.segmentCacheManager = segmentCacheManager;
        this.jsonMapper = jsonMapper;
        this.taskWorkDir = taskWorkDir;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.taskReportFileWriter.setObjectMapper(this.jsonMapper);
        this.intermediaryDataManager = intermediaryDataManager;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.appenderatorsManager = appenderatorsManager;
        this.overlordClient = overlordClient;
        this.coordinatorClient = coordinatorClient;
        this.supervisorTaskClientProvider = supervisorTaskClientProvider;
        this.shuffleClient = shuffleClient;
        this.taskLogPusher = taskLogPusher;
        this.attemptId = attemptId;
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public DruidNode getTaskExecutorNode() {
        return this.taskExecutorNode;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClient;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public DataSegmentServerAnnouncer getDataSegmentServerAnnouncer() {
        return this.serverAnnouncer;
    }

    public SegmentHandoffNotifierFactory getSegmentHandoffNotifierFactory() {
        return this.handoffNotifierFactory;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return (QueryRunnerFactoryConglomerate)this.queryRunnerFactoryConglomerateProvider.get();
    }

    public QueryProcessingPool getQueryProcessingPool() {
        return this.queryProcessingPool;
    }

    public JoinableFactory getJoinableFactory() {
        return this.joinableFactory;
    }

    @Nullable
    public MonitorScheduler getMonitorScheduler() {
        return this.monitorSchedulerProvider == null ? null : (MonitorScheduler)this.monitorSchedulerProvider.get();
    }

    public void addMonitor(Monitor monitor) {
        MonitorScheduler scheduler = this.getMonitorScheduler();
        if (scheduler != null) {
            scheduler.addMonitor(monitor);
        }
    }

    public void removeMonitor(Monitor monitor) {
        MonitorScheduler scheduler = this.getMonitorScheduler();
        if (scheduler != null) {
            scheduler.removeMonitor(monitor);
        }
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public SegmentCacheManager getSegmentCacheManager() {
        return this.segmentCacheManager;
    }

    public void publishSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, DataSegment::getInterval);
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(SegmentTransactionalInsertAction.appendAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection), null, null));
        }
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public CachePopulatorStats getCachePopulatorStats() {
        return this.cachePopulatorStats;
    }

    public IndexMergerV9 getIndexMergerV9() {
        return this.indexMergerV9;
    }

    public File getIndexingTmpDir() {
        File tmpDir = new File(this.taskWorkDir, "indexing-tmp");
        try {
            FileUtils.mkdirp((File)tmpDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tmpDir;
    }

    public File getMergeDir() {
        return new File(this.taskWorkDir, "merge");
    }

    public File getPersistDir() {
        return new File(this.taskWorkDir, "persist");
    }

    public DruidNodeAnnouncer getDruidNodeAnnouncer() {
        return this.druidNodeAnnouncer;
    }

    public LookupNodeService getLookupNodeService() {
        return this.lookupNodeService;
    }

    public DataNodeService getDataNodeService() {
        return this.dataNodeService;
    }

    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public TaskReportFileWriter getTaskReportFileWriter() {
        return this.taskReportFileWriter;
    }

    public IntermediaryDataManager getIntermediaryDataManager() {
        return this.intermediaryDataManager;
    }

    public AuthorizerMapper getAuthorizerMapper() {
        return this.authorizerMapper;
    }

    public ChatHandlerProvider getChatHandlerProvider() {
        return this.chatHandlerProvider;
    }

    public RowIngestionMetersFactory getRowIngestionMetersFactory() {
        return this.rowIngestionMetersFactory;
    }

    public AppenderatorsManager getAppenderatorsManager() {
        return this.appenderatorsManager;
    }

    public OverlordClient getOverlordClient() {
        return this.overlordClient;
    }

    public CoordinatorClient getCoordinatorClient() {
        return this.coordinatorClient;
    }

    public ParallelIndexSupervisorTaskClientProvider getSupervisorTaskClientProvider() {
        return this.supervisorTaskClientProvider;
    }

    public ShuffleClient getShuffleClient() {
        return this.shuffleClient;
    }

    public TaskLogPusher getTaskLogPusher() {
        return this.taskLogPusher;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public static class Builder {
        private TaskConfig config;
        private DruidNode taskExecutorNode;
        private TaskActionClient taskActionClient;
        private ServiceEmitter emitter;
        private DataSegmentPusher segmentPusher;
        private DataSegmentKiller dataSegmentKiller;
        private DataSegmentMover dataSegmentMover;
        private DataSegmentArchiver dataSegmentArchiver;
        private DataSegmentAnnouncer segmentAnnouncer;
        private DataSegmentServerAnnouncer serverAnnouncer;
        private SegmentHandoffNotifierFactory handoffNotifierFactory;
        private Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
        private QueryProcessingPool queryProcessingPool;
        private JoinableFactory joinableFactory;
        private Provider<MonitorScheduler> monitorSchedulerProvider;
        private SegmentCacheManager segmentCacheManager;
        private ObjectMapper jsonMapper;
        private File taskWorkDir;
        private IndexIO indexIO;
        private Cache cache;
        private CacheConfig cacheConfig;
        private CachePopulatorStats cachePopulatorStats;
        private IndexMergerV9 indexMergerV9;
        private DruidNodeAnnouncer druidNodeAnnouncer;
        private DruidNode druidNode;
        private LookupNodeService lookupNodeService;
        private DataNodeService dataNodeService;
        private TaskReportFileWriter taskReportFileWriter;
        private AuthorizerMapper authorizerMapper;
        private ChatHandlerProvider chatHandlerProvider;
        private RowIngestionMetersFactory rowIngestionMetersFactory;
        private AppenderatorsManager appenderatorsManager;
        private OverlordClient overlordClient;
        private CoordinatorClient coordinatorClient;
        private IntermediaryDataManager intermediaryDataManager;
        private ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider;
        private ShuffleClient shuffleClient;
        private TaskLogPusher taskLogPusher;
        private String attemptId;

        public Builder() {
        }

        public Builder(TaskToolbox other) {
            this.config = other.config;
            this.taskExecutorNode = other.taskExecutorNode;
            this.taskActionClient = other.taskActionClient;
            this.emitter = other.emitter;
            this.segmentPusher = other.segmentPusher;
            this.dataSegmentKiller = other.dataSegmentKiller;
            this.dataSegmentMover = other.dataSegmentMover;
            this.dataSegmentArchiver = other.dataSegmentArchiver;
            this.segmentAnnouncer = other.segmentAnnouncer;
            this.serverAnnouncer = other.serverAnnouncer;
            this.handoffNotifierFactory = other.handoffNotifierFactory;
            this.queryRunnerFactoryConglomerateProvider = other.queryRunnerFactoryConglomerateProvider;
            this.queryProcessingPool = other.queryProcessingPool;
            this.joinableFactory = other.joinableFactory;
            this.monitorSchedulerProvider = other.monitorSchedulerProvider;
            this.segmentCacheManager = other.segmentCacheManager;
            this.jsonMapper = other.jsonMapper;
            this.taskWorkDir = other.taskWorkDir;
            this.indexIO = other.indexIO;
            this.cache = other.cache;
            this.cacheConfig = other.cacheConfig;
            this.cachePopulatorStats = other.cachePopulatorStats;
            this.indexMergerV9 = other.indexMergerV9;
            this.druidNodeAnnouncer = other.druidNodeAnnouncer;
            this.druidNode = other.druidNode;
            this.lookupNodeService = other.lookupNodeService;
            this.dataNodeService = other.dataNodeService;
            this.taskReportFileWriter = other.taskReportFileWriter;
            this.authorizerMapper = other.authorizerMapper;
            this.chatHandlerProvider = other.chatHandlerProvider;
            this.rowIngestionMetersFactory = other.rowIngestionMetersFactory;
            this.appenderatorsManager = other.appenderatorsManager;
            this.overlordClient = other.overlordClient;
            this.coordinatorClient = other.coordinatorClient;
            this.intermediaryDataManager = other.intermediaryDataManager;
            this.supervisorTaskClientProvider = other.supervisorTaskClientProvider;
            this.shuffleClient = other.shuffleClient;
        }

        public Builder config(TaskConfig config) {
            this.config = config;
            return this;
        }

        public Builder taskExecutorNode(DruidNode taskExecutorNode) {
            this.taskExecutorNode = taskExecutorNode;
            return this;
        }

        public Builder taskActionClient(TaskActionClient taskActionClient) {
            this.taskActionClient = taskActionClient;
            return this;
        }

        public Builder emitter(ServiceEmitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public Builder segmentPusher(DataSegmentPusher segmentPusher) {
            this.segmentPusher = segmentPusher;
            return this;
        }

        public Builder dataSegmentKiller(DataSegmentKiller dataSegmentKiller) {
            this.dataSegmentKiller = dataSegmentKiller;
            return this;
        }

        public Builder dataSegmentMover(DataSegmentMover dataSegmentMover) {
            this.dataSegmentMover = dataSegmentMover;
            return this;
        }

        public Builder dataSegmentArchiver(DataSegmentArchiver dataSegmentArchiver) {
            this.dataSegmentArchiver = dataSegmentArchiver;
            return this;
        }

        public Builder segmentAnnouncer(DataSegmentAnnouncer segmentAnnouncer) {
            this.segmentAnnouncer = segmentAnnouncer;
            return this;
        }

        public Builder serverAnnouncer(DataSegmentServerAnnouncer serverAnnouncer) {
            this.serverAnnouncer = serverAnnouncer;
            return this;
        }

        public Builder handoffNotifierFactory(SegmentHandoffNotifierFactory handoffNotifierFactory) {
            this.handoffNotifierFactory = handoffNotifierFactory;
            return this;
        }

        public Builder queryRunnerFactoryConglomerateProvider(Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider) {
            this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
            return this;
        }

        public Builder queryProcessingPool(QueryProcessingPool queryProcessingPool) {
            this.queryProcessingPool = queryProcessingPool;
            return this;
        }

        public Builder joinableFactory(JoinableFactory joinableFactory) {
            this.joinableFactory = joinableFactory;
            return this;
        }

        public Builder monitorSchedulerProvider(Provider<MonitorScheduler> monitorSchedulerProvider) {
            this.monitorSchedulerProvider = monitorSchedulerProvider;
            return this;
        }

        public Builder segmentCacheManager(SegmentCacheManager segmentCacheManager) {
            this.segmentCacheManager = segmentCacheManager;
            return this;
        }

        public Builder jsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        public Builder taskWorkDir(File taskWorkDir) {
            this.taskWorkDir = taskWorkDir;
            return this;
        }

        public Builder indexIO(IndexIO indexIO) {
            this.indexIO = indexIO;
            return this;
        }

        public Builder cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        public Builder cachePopulatorStats(CachePopulatorStats cachePopulatorStats) {
            this.cachePopulatorStats = cachePopulatorStats;
            return this;
        }

        public Builder indexMergerV9(IndexMergerV9 indexMergerV9) {
            this.indexMergerV9 = indexMergerV9;
            return this;
        }

        public Builder druidNodeAnnouncer(DruidNodeAnnouncer druidNodeAnnouncer) {
            this.druidNodeAnnouncer = druidNodeAnnouncer;
            return this;
        }

        public Builder druidNode(DruidNode druidNode) {
            this.druidNode = druidNode;
            return this;
        }

        public Builder lookupNodeService(LookupNodeService lookupNodeService) {
            this.lookupNodeService = lookupNodeService;
            return this;
        }

        public Builder dataNodeService(DataNodeService dataNodeService) {
            this.dataNodeService = dataNodeService;
            return this;
        }

        public Builder taskReportFileWriter(TaskReportFileWriter taskReportFileWriter) {
            this.taskReportFileWriter = taskReportFileWriter;
            return this;
        }

        public Builder authorizerMapper(AuthorizerMapper authorizerMapper) {
            this.authorizerMapper = authorizerMapper;
            return this;
        }

        public Builder chatHandlerProvider(ChatHandlerProvider chatHandlerProvider) {
            this.chatHandlerProvider = chatHandlerProvider;
            return this;
        }

        public Builder rowIngestionMetersFactory(RowIngestionMetersFactory rowIngestionMetersFactory) {
            this.rowIngestionMetersFactory = rowIngestionMetersFactory;
            return this;
        }

        public Builder appenderatorsManager(AppenderatorsManager appenderatorsManager) {
            this.appenderatorsManager = appenderatorsManager;
            return this;
        }

        public Builder overlordClient(OverlordClient overlordClient) {
            this.overlordClient = overlordClient;
            return this;
        }

        public Builder coordinatorClient(CoordinatorClient coordinatorClient) {
            this.coordinatorClient = coordinatorClient;
            return this;
        }

        public Builder intermediaryDataManager(IntermediaryDataManager intermediaryDataManager) {
            this.intermediaryDataManager = intermediaryDataManager;
            return this;
        }

        public Builder supervisorTaskClientProvider(ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider) {
            this.supervisorTaskClientProvider = supervisorTaskClientProvider;
            return this;
        }

        public Builder shuffleClient(ShuffleClient shuffleClient) {
            this.shuffleClient = shuffleClient;
            return this;
        }

        public Builder taskLogPusher(TaskLogPusher taskLogPusher) {
            this.taskLogPusher = taskLogPusher;
            return this;
        }

        public Builder attemptId(String attemptId) {
            this.attemptId = attemptId;
            return this;
        }

        public TaskToolbox build() {
            return new TaskToolbox(this.config, this.taskExecutorNode, this.taskActionClient, this.emitter, this.segmentPusher, this.dataSegmentKiller, this.dataSegmentMover, this.dataSegmentArchiver, this.segmentAnnouncer, this.serverAnnouncer, this.handoffNotifierFactory, this.queryRunnerFactoryConglomerateProvider, this.queryProcessingPool, this.joinableFactory, this.monitorSchedulerProvider, this.segmentCacheManager, this.jsonMapper, this.taskWorkDir, this.indexIO, this.cache, this.cacheConfig, this.cachePopulatorStats, this.indexMergerV9, this.druidNodeAnnouncer, this.druidNode, this.lookupNodeService, this.dataNodeService, this.taskReportFileWriter, this.intermediaryDataManager, this.authorizerMapper, this.chatHandlerProvider, this.rowIngestionMetersFactory, this.appenderatorsManager, this.overlordClient, this.coordinatorClient, this.supervisorTaskClientProvider, this.shuffleClient, this.taskLogPusher, this.attemptId);
        }
    }
}

