/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.indexing.common.SingleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class MultipleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(MultipleFileTaskReportFileWriter.class);
    private final Map<String, File> taskReportFiles = new HashMap<String, File>();
    private ObjectMapper objectMapper;

    @Override
    public void write(String taskId, Map<String, TaskReport> reports) {
        File reportsFile = this.taskReportFiles.get(taskId);
        if (reportsFile == null) {
            log.error("Could not find report file for task[%s]", new Object[]{taskId});
            return;
        }
        try {
            File reportsFileParent = reportsFile.getParentFile();
            if (reportsFileParent != null) {
                FileUtils.mkdirp((File)reportsFileParent);
            }
            try (FileOutputStream outputStream = new FileOutputStream(reportsFile);){
                SingleFileTaskReportFileWriter.writeReportToStream(this.objectMapper, outputStream, reports);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in write().", new Object[0]);
        }
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void add(String taskId, File reportsFile) {
        this.taskReportFiles.put(taskId, reportsFile);
    }

    public void delete(String taskId) {
        this.taskReportFiles.remove(taskId);
    }
}

