/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.BadQueryException;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlExecutionReporter;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.utils.CloseableUtils;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    public static final String SQL_QUERY_ID_RESPONSE_HEADER = "X-Druid-SQL-Query-Id";
    public static final String SQL_HEADER_RESPONSE_HEADER = "X-Druid-SQL-Header-Included";
    public static final String SQL_HEADER_VALUE = "yes";
    private static final Logger log = new Logger(SqlResource.class);
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;
    private final SqlStatementFactory sqlStatementFactory;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final ServerConfig serverConfig;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;

    @Inject
    SqlResource(ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, @NativeQuery SqlStatementFactory sqlStatementFactory, SqlLifecycleManager sqlLifecycleManager, ServerConfig serverConfig, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.authorizerMapper = (AuthorizerMapper)Preconditions.checkNotNull((Object)authorizerMapper, (Object)"authorizerMapper");
        this.sqlStatementFactory = (SqlStatementFactory)Preconditions.checkNotNull((Object)sqlStatementFactory, (Object)"sqlStatementFactory");
        this.sqlLifecycleManager = (SqlLifecycleManager)Preconditions.checkNotNull((Object)sqlLifecycleManager, (Object)"sqlLifecycleManager");
        this.serverConfig = (ServerConfig)Preconditions.checkNotNull((Object)serverConfig, (Object)"serverConfig");
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(final SqlQuery sqlQuery, @Context HttpServletRequest req) throws IOException {
        final HttpStatement stmt = this.sqlStatementFactory.httpStatement(sqlQuery, req);
        final String sqlQueryId = stmt.sqlQueryId();
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{sqlQueryId}));
            DirectStatement.ResultSet resultSet = stmt.plan();
            QueryResponse<Object[]> response = resultSet.run();
            final SqlRowTransformer rowTransformer = resultSet.createRowTransformer();
            final Yielder finalYielder = Yielders.each((Sequence)response.getResults());
            Response.ResponseBuilder responseBuilder = Response.ok((Object)new StreamingOutput(){

                public void write(OutputStream output) throws IOException, WebApplicationException {
                    Exception finalE;
                    Exception e = null;
                    CountingOutputStream os = new CountingOutputStream(output);
                    Yielder yielder = finalYielder;
                    try {
                        try (ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, SqlResource.this.jsonMapper);){
                            writer.writeResponseStart();
                            if (sqlQuery.includeHeader()) {
                                writer.writeHeader(rowTransformer.getRowType(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader());
                            }
                            while (!yielder.isDone()) {
                                Object[] row = (Object[])yielder.get();
                                writer.writeRowStart();
                                for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                                    Object value = rowTransformer.transform(row, i);
                                    writer.writeRowField(rowTransformer.getFieldList().get(i), value);
                                }
                                writer.writeRowEnd();
                                yielder = yielder.next(null);
                            }
                            writer.writeResponseEnd();
                        }
                        finalE = e;
                    }
                    catch (Exception ex) {
                        try {
                            e = ex;
                            log.error((Throwable)ex, "Unable to send SQL response [%s]", new Object[]{sqlQueryId});
                            throw new RuntimeException(ex);
                        }
                        catch (Throwable throwable) {
                            Exception finalE2 = e;
                            CloseableUtils.closeAll((Closeable)yielder, (Closeable[])new Closeable[]{() -> SqlResource.this.endLifecycle(stmt, finalE2, os.getCount())});
                            throw throwable;
                        }
                    }
                    CloseableUtils.closeAll((Closeable)yielder, (Closeable[])new Closeable[]{() -> SqlResource.this.endLifecycle(stmt, finalE2, os.getCount())});
                }
            }).header(SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId);
            if (sqlQuery.includeHeader()) {
                responseBuilder.header(SQL_HEADER_RESPONSE_HEADER, (Object)SQL_HEADER_VALUE);
            }
            QueryResource.attachResponseContextToHttpResponse((String)sqlQueryId, (ResponseContext)response.getResponseContext(), (Response.ResponseBuilder)responseBuilder, (ObjectMapper)this.jsonMapper, (ResponseContextConfig)this.responseContextConfig, (DruidNode)this.selfNode);
            Response response2 = responseBuilder.build();
            return response2;
        }
        catch (QueryCapacityExceededException cap) {
            this.endLifecycle(stmt, cap, -1L);
            Response response = this.buildNonOkResponse(429, (SanitizableException)cap, sqlQueryId);
            return response;
        }
        catch (QueryUnsupportedException unsupported) {
            this.endLifecycle(stmt, unsupported, -1L);
            Response response = this.buildNonOkResponse(501, (SanitizableException)unsupported, sqlQueryId);
            return response;
        }
        catch (QueryTimeoutException timeout) {
            this.endLifecycle(stmt, timeout, -1L);
            Response response = this.buildNonOkResponse(504, (SanitizableException)timeout, sqlQueryId);
            return response;
        }
        catch (BadQueryException e) {
            this.endLifecycle(stmt, e, -1L);
            Response response = this.buildNonOkResponse(400, (SanitizableException)e, sqlQueryId);
            return response;
        }
        catch (ForbiddenException e) {
            this.endLifecycleWithoutEmittingMetrics(stmt);
            throw (ForbiddenException)((Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)e));
        }
        catch (RelOptPlanner.CannotPlanException e) {
            this.endLifecycle(stmt, e, -1L);
            SqlPlanningException spe = new SqlPlanningException(SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR, e.getMessage());
            Response response = this.buildNonOkResponse(400, (SanitizableException)spe, sqlQueryId);
            return response;
        }
        catch (Throwable e) {
            log.warn(e, "Failed to handle query: %s", new Object[]{sqlQuery});
            this.endLifecycle(stmt, e, -1L);
            Response response = this.buildNonOkResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (SanitizableException)QueryInterruptedException.wrapIfNeeded((Throwable)e), sqlQueryId);
            return response;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private void endLifecycleWithoutEmittingMetrics(HttpStatement stmt) {
        stmt.closeQuietly();
    }

    private void endLifecycle(HttpStatement stmt, @Nullable Throwable e, long bytesWritten) {
        SqlExecutionReporter reporter = stmt.reporter();
        if (e == null) {
            reporter.succeeded(bytesWritten);
        } else {
            reporter.failed(e);
        }
        stmt.close();
    }

    private Response buildNonOkResponse(int status, SanitizableException e, String sqlQueryId) throws JsonProcessingException {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.jsonMapper.writeValueAsBytes((Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded(e))).header(SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId).build();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query [%s]", new Object[]{sqlQueryId});
        List<SqlLifecycleManager.Cancelable> lifecycles = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (lifecycles.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Set resources = lifecycles.stream().flatMap(lifecycle -> lifecycle.resources().stream()).collect(Collectors.toSet());
        Access access = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resources, (AuthorizerMapper)this.authorizerMapper);
        if (access.isAllowed()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, lifecycles);
            lifecycles.forEach(SqlLifecycleManager.Cancelable::cancel);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

