/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DatasourceTable
extends DruidTable {
    private final PhysicalDatasourceMetadata physicalMetadata;

    public DatasourceTable(PhysicalDatasourceMetadata physicalMetadata) {
        super(physicalMetadata.rowSignature());
        this.physicalMetadata = physicalMetadata;
    }

    @Override
    public DataSource getDataSource() {
        return this.physicalMetadata.dataSource();
    }

    @Override
    public boolean isJoinable() {
        return this.physicalMetadata.isJoinable();
    }

    @Override
    public boolean isBroadcast() {
        return this.physicalMetadata.isBroadcast();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasourceTable that = (DatasourceTable)o;
        if (!Objects.equals(this.physicalMetadata, that.physicalMetadata)) {
            return false;
        }
        return Objects.equals(this.getRowSignature(), that.getRowSignature());
    }

    public int hashCode() {
        return this.physicalMetadata.hashCode();
    }

    public String toString() {
        return "DruidTable{" + this.physicalMetadata + '}';
    }

    public static class PhysicalDatasourceMetadata {
        private final TableDataSource dataSource;
        private final RowSignature rowSignature;
        private final boolean joinable;
        private final boolean broadcast;

        public PhysicalDatasourceMetadata(TableDataSource dataSource, RowSignature rowSignature, boolean isJoinable, boolean isBroadcast) {
            this.dataSource = (TableDataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
            this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
            this.joinable = isJoinable;
            this.broadcast = isBroadcast;
        }

        public TableDataSource dataSource() {
            return this.dataSource;
        }

        public RowSignature rowSignature() {
            return this.rowSignature;
        }

        public boolean isJoinable() {
            return this.joinable;
        }

        public boolean isBroadcast() {
            return this.broadcast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhysicalDatasourceMetadata that = (PhysicalDatasourceMetadata)o;
            if (!Objects.equals(this.dataSource, that.dataSource)) {
                return false;
            }
            return Objects.equals(this.rowSignature, that.rowSignature);
        }

        public int hashCode() {
            int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
            result = 31 * result + (this.rowSignature != null ? this.rowSignature.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DatasourceMetadata{dataSource=" + this.dataSource + ", rowSignature=" + this.rowSignature + '}';
        }
    }
}

