/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedSchema;

public class RootSchemaProvider
implements Provider<DruidSchemaCatalog> {
    private final Set<NamedSchema> namedSchemas;

    @Inject
    RootSchemaProvider(Set<NamedSchema> namedSchemas) {
        this.namedSchemas = namedSchemas;
    }

    public DruidSchemaCatalog get() {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        HashMap schemasByName = Maps.newHashMapWithExpectedSize((int)this.namedSchemas.size());
        for (NamedSchema schema : this.namedSchemas) {
            if (schemasByName.containsKey(schema.getSchemaName())) {
                throw new ISE("Found multiple schemas registered to the same name. The list of registered schemas are %s", new Object[]{this.namedSchemas.stream().map(NamedSchema::getSchemaName).collect(Collectors.toList())});
            }
            schemasByName.put(schema.getSchemaName(), schema);
            rootSchema.add(schema.getSchemaName(), schema.getSchema());
        }
        return new DruidSchemaCatalog(rootSchema, (Map<String, NamedSchema>)ImmutableMap.copyOf((Map)schemasByName));
    }
}

