/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class InformationSchema
extends AbstractSchema {
    private static final EmittingLogger log = new EmittingLogger(InformationSchema.class);
    private static final String CATALOG_NAME = "druid";
    private static final String SCHEMATA_TABLE = "SCHEMATA";
    private static final String TABLES_TABLE = "TABLES";
    private static final String COLUMNS_TABLE = "COLUMNS";
    private static final RowSignature SCHEMATA_SIGNATURE = RowSignature.builder().add("CATALOG_NAME", ColumnType.STRING).add("SCHEMA_NAME", ColumnType.STRING).add("SCHEMA_OWNER", ColumnType.STRING).add("DEFAULT_CHARACTER_SET_CATALOG", ColumnType.STRING).add("DEFAULT_CHARACTER_SET_SCHEMA", ColumnType.STRING).add("DEFAULT_CHARACTER_SET_NAME", ColumnType.STRING).add("SQL_PATH", ColumnType.STRING).build();
    private static final RowSignature TABLES_SIGNATURE = RowSignature.builder().add("TABLE_CATALOG", ColumnType.STRING).add("TABLE_SCHEMA", ColumnType.STRING).add("TABLE_NAME", ColumnType.STRING).add("TABLE_TYPE", ColumnType.STRING).add("IS_JOINABLE", ColumnType.STRING).add("IS_BROADCAST", ColumnType.STRING).build();
    private static final RowSignature COLUMNS_SIGNATURE = RowSignature.builder().add("TABLE_CATALOG", ColumnType.STRING).add("TABLE_SCHEMA", ColumnType.STRING).add("TABLE_NAME", ColumnType.STRING).add("COLUMN_NAME", ColumnType.STRING).add("ORDINAL_POSITION", ColumnType.STRING).add("COLUMN_DEFAULT", ColumnType.STRING).add("IS_NULLABLE", ColumnType.STRING).add("DATA_TYPE", ColumnType.STRING).add("CHARACTER_MAXIMUM_LENGTH", ColumnType.STRING).add("CHARACTER_OCTET_LENGTH", ColumnType.STRING).add("NUMERIC_PRECISION", ColumnType.STRING).add("NUMERIC_PRECISION_RADIX", ColumnType.STRING).add("NUMERIC_SCALE", ColumnType.STRING).add("DATETIME_PRECISION", ColumnType.STRING).add("CHARACTER_SET_NAME", ColumnType.STRING).add("COLLATION_NAME", ColumnType.STRING).add("JDBC_TYPE", ColumnType.LONG).build();
    private static final RelDataTypeSystem TYPE_SYSTEM = RelDataTypeSystem.DEFAULT;
    private static final String INFO_TRUE = "YES";
    private static final String INFO_FALSE = "NO";
    private final DruidSchemaCatalog rootSchema;
    private final Map<String, Table> tableMap;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public InformationSchema(@Named(value="INCOMPLETE_SCHEMA") DruidSchemaCatalog rootSchema, AuthorizerMapper authorizerMapper) {
        this.rootSchema = (DruidSchemaCatalog)Preconditions.checkNotNull((Object)rootSchema, (Object)"rootSchema");
        this.tableMap = ImmutableMap.of((Object)SCHEMATA_TABLE, (Object)((Object)new SchemataTable()), (Object)TABLES_TABLE, (Object)((Object)new TablesTable()), (Object)COLUMNS_TABLE, (Object)((Object)new ColumnsTable()));
        this.authorizerMapper = authorizerMapper;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Nullable
    private static TableMacro getView(SchemaPlus schemaPlus, String functionName) {
        Collection functions = schemaPlus.getFunctions(functionName);
        for (org.apache.calcite.schema.Function function : functions) {
            if (!function.getParameters().isEmpty() || !(function instanceof TableMacro)) continue;
            return (TableMacro)function;
        }
        return null;
    }

    private Set<String> getAuthorizedTableNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        return this.getAuthorizedNamesFromNamedSchema(authenticationResult, this.rootSchema.getNamedSchema(subSchema.getName()), subSchema.getTableNames());
    }

    private Set<String> getAuthorizedFunctionNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        return this.getAuthorizedNamesFromNamedSchema(authenticationResult, this.rootSchema.getNamedSchema(subSchema.getName()), subSchema.getFunctionNames());
    }

    private Set<String> getAuthorizedNamesFromNamedSchema(AuthenticationResult authenticationResult, NamedSchema schema, Set<String> names) {
        if (schema != null) {
            return ImmutableSet.copyOf((Iterable)AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, names, name -> {
                String resoureType = schema.getSchemaResourceType((String)name);
                if (resoureType != null) {
                    return Collections.singletonList(new ResourceAction(new Resource(name, resoureType), Action.READ));
                }
                return Collections.emptyList();
            }, (AuthorizerMapper)this.authorizerMapper));
        }
        return names;
    }

    class ColumnsTable
    extends AbstractTable
    implements ScannableTable {
        ColumnsTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    final JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(TYPE_SYSTEM);
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.concat((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform((Function)new Function<String, Iterable<Object[]>>(){

                        public Iterable<Object[]> apply(String tableName) {
                            return ColumnsTable.this.generateColumnMetadata(schemaName, tableName, subSchema.getTable(tableName), (RelDataTypeFactory)typeFactory);
                        }
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Iterable<Object[]>>(){

                        public Iterable<Object[]> apply(String functionName) {
                            TableMacro viewMacro = InformationSchema.getView(subSchema, functionName);
                            if (viewMacro == null) {
                                return null;
                            }
                            try {
                                return ColumnsTable.this.generateColumnMetadata(schemaName, functionName, (Table)viewMacro.apply(Collections.emptyList()), (RelDataTypeFactory)typeFactory);
                            }
                            catch (Exception e) {
                                log.error((Throwable)e, "Encountered exception while handling view[%s].", new Object[]{functionName});
                                return null;
                            }
                        }
                    })), (Predicate)Predicates.notNull()));
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(COLUMNS_SIGNATURE, typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        @Nullable
        private Iterable<Object[]> generateColumnMetadata(final String schemaName, final String tableName, Table table, RelDataTypeFactory typeFactory) {
            if (table == null) {
                return null;
            }
            return FluentIterable.from((Iterable)table.getRowType(typeFactory).getFieldList()).transform((Function)new Function<RelDataTypeField, Object[]>(){

                public Object[] apply(RelDataTypeField field) {
                    RelDataType type = field.getType();
                    boolean isNumeric = SqlTypeName.NUMERIC_TYPES.contains(type.getSqlTypeName());
                    boolean isCharacter = SqlTypeName.CHAR_TYPES.contains(type.getSqlTypeName());
                    boolean isDateTime = SqlTypeName.DATETIME_TYPES.contains(type.getSqlTypeName());
                    String typeName = type instanceof RowSignatures.ComplexSqlType ? ((RowSignatures.ComplexSqlType)type).asTypeString() : type.getSqlTypeName().toString();
                    return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, field.getName(), String.valueOf(field.getIndex()), "", type.isNullable() ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE, typeName, null, null, isNumeric ? String.valueOf(type.getPrecision()) : null, isNumeric ? "10" : null, isNumeric ? String.valueOf(type.getScale()) : null, isDateTime ? String.valueOf(type.getPrecision()) : null, isCharacter ? type.getCharset().name() : null, isCharacter ? type.getCollation().getCollationName() : null, (long)type.getSqlTypeName().getJdbcOrdinal()};
                }
            });
        }
    }

    class TablesTable
    extends AbstractTable
    implements ScannableTable {
        TablesTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform(tableName -> {
                        boolean isBroadcast;
                        boolean isJoinable;
                        Table table = subSchema.getTable(tableName);
                        if (table instanceof DruidTable) {
                            DruidTable druidTable = (DruidTable)table;
                            isJoinable = druidTable.isJoinable();
                            isBroadcast = druidTable.isBroadcast();
                        } else {
                            isJoinable = false;
                            isBroadcast = false;
                        }
                        return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, table.getJdbcTableType().toString(), isJoinable ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE, isBroadcast ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE};
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Object[]>(){

                        public Object[] apply(String functionName) {
                            if (InformationSchema.getView(subSchema, functionName) != null) {
                                return new Object[]{InformationSchema.CATALOG_NAME, schemaName, functionName, "VIEW", InformationSchema.INFO_FALSE, InformationSchema.INFO_FALSE};
                            }
                            return null;
                        }
                    })), (Predicate)Predicates.notNull());
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(TABLES_SIGNATURE, typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }

    class SchemataTable
    extends AbstractTable
    implements ScannableTable {
        SchemataTable() {
        }

        public Enumerable<Object[]> scan(DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transform((Function)new Function<String, Object[]>(){

                public Object[] apply(String schemaName) {
                    SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    return new Object[]{InformationSchema.CATALOG_NAME, subSchema.getName(), null, null, null, null, null};
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SCHEMATA_SIGNATURE, typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }
}

