/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import java.util.Set;
import javax.inject.Inject;
import org.apache.calcite.schema.Table;
import org.apache.druid.sql.calcite.schema.AbstractTableSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.schema.SegmentMetadataCache;
import org.apache.druid.sql.calcite.table.DatasourceTable;

public class DruidSchema
extends AbstractTableSchema {
    private final SegmentMetadataCache segmentCache;
    private final DruidSchemaManager druidSchemaManager;

    @Inject
    public DruidSchema(SegmentMetadataCache segmentCache, DruidSchemaManager druidSchemaManager) {
        this.segmentCache = segmentCache;
        this.druidSchemaManager = druidSchemaManager != null && !(druidSchemaManager instanceof NoopDruidSchemaManager) ? druidSchemaManager : null;
    }

    protected SegmentMetadataCache cache() {
        return this.segmentCache;
    }

    public Table getTable(String name) {
        if (this.druidSchemaManager != null) {
            return this.druidSchemaManager.getTable(name);
        }
        DatasourceTable.PhysicalDatasourceMetadata dsMetadata = this.segmentCache.getDatasource(name);
        return dsMetadata == null ? null : new DatasourceTable(dsMetadata);
    }

    public Set<String> getTableNames() {
        if (this.druidSchemaManager != null) {
            return this.druidSchemaManager.getTableNames();
        }
        return this.segmentCache.getDatasourceNames();
    }
}

