/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.rule.DruidUnionDataSourceRule;

public class DruidUnionRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public DruidUnionRule(PlannerContext plannerContext) {
        super(DruidUnionRule.operand(Union.class, (RelOptRuleOperand)DruidUnionRule.operand(DruidRel.class, (RelOptRuleOperandChildren)DruidUnionRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[]{DruidUnionRule.operand(DruidRel.class, (RelOptRuleOperandChildren)DruidUnionRule.none())}));
        this.plannerContext = plannerContext;
    }

    public boolean matches(RelOptRuleCall call) {
        DruidRel secondDruidRel;
        DruidRel firstDruidRel;
        Union unionRel = (Union)call.rel(0);
        return !DruidUnionDataSourceRule.isCompatible(unionRel, firstDruidRel = (DruidRel)call.rel(1), secondDruidRel = (DruidRel)call.rel(2), null);
    }

    public void onMatch(RelOptRuleCall call) {
        Union unionRel = (Union)call.rel(0);
        DruidRel someDruidRel = (DruidRel)call.rel(1);
        List inputs = unionRel.getInputs();
        if (unionRel.all) {
            call.transformTo((RelNode)DruidUnionRel.create(someDruidRel.getPlannerContext(), unionRel.getRowType(), inputs, -1));
        } else {
            this.plannerContext.setPlanningError("SQL requires 'UNION' but only 'UNION ALL' is supported.", new Object[0]);
        }
    }
}

