/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class PartialDruidQuery {
    private final Supplier<RelBuilder> builderSupplier;
    private final RelNode scan;
    private final Filter whereFilter;
    private final Project selectProject;
    private final Aggregate aggregate;
    private final Filter havingFilter;
    private final Project aggregateProject;
    private final Sort sort;
    private final Project sortProject;

    private PartialDruidQuery(Supplier<RelBuilder> builderSupplier, RelNode scan, Filter whereFilter, Project selectProject, Aggregate aggregate, Project aggregateProject, Filter havingFilter, Sort sort, Project sortProject) {
        this.builderSupplier = (Supplier)Preconditions.checkNotNull(builderSupplier, (Object)"builderSupplier");
        this.scan = (RelNode)Preconditions.checkNotNull((Object)scan, (Object)"scan");
        this.whereFilter = whereFilter;
        this.selectProject = selectProject;
        this.aggregate = aggregate;
        this.aggregateProject = aggregateProject;
        this.havingFilter = havingFilter;
        this.sort = sort;
        this.sortProject = sortProject;
    }

    public static PartialDruidQuery create(RelNode scanRel) {
        Supplier<RelBuilder> builderSupplier = () -> RelFactories.LOGICAL_BUILDER.create(scanRel.getCluster(), scanRel.getTable() != null ? scanRel.getTable().getRelOptSchema() : null);
        return new PartialDruidQuery(builderSupplier, scanRel, null, null, null, null, null, null, null);
    }

    public RelNode getScan() {
        return this.scan;
    }

    public Filter getWhereFilter() {
        return this.whereFilter;
    }

    public Project getSelectProject() {
        return this.selectProject;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public Filter getHavingFilter() {
        return this.havingFilter;
    }

    public Project getAggregateProject() {
        return this.aggregateProject;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Project getSortProject() {
        return this.sortProject;
    }

    public PartialDruidQuery withWhereFilter(Filter newWhereFilter) {
        this.validateStage(Stage.WHERE_FILTER);
        return new PartialDruidQuery(this.builderSupplier, this.scan, newWhereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject);
    }

    public PartialDruidQuery withSelectProject(Project newSelectProject) {
        Project theProject;
        this.validateStage(Stage.SELECT_PROJECT);
        if (this.selectProject == null) {
            theProject = newSelectProject;
        } else {
            List newProjectRexNodes = RelOptUtil.pushPastProject((List)newSelectProject.getProjects(), (Project)this.selectProject);
            if (RexUtil.isIdentity((List)newProjectRexNodes, (RelDataType)this.selectProject.getInput().getRowType())) {
                theProject = null;
            } else {
                RelBuilder relBuilder = this.builderSupplier.get();
                relBuilder.push(this.selectProject.getInput());
                relBuilder.project((Iterable)newProjectRexNodes, (Iterable)newSelectProject.getRowType().getFieldNames(), true);
                theProject = (Project)relBuilder.build();
            }
        }
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, theProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject);
    }

    public PartialDruidQuery withAggregate(Aggregate newAggregate) {
        this.validateStage(Stage.AGGREGATE);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, newAggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject);
    }

    public PartialDruidQuery withHavingFilter(Filter newHavingFilter) {
        this.validateStage(Stage.HAVING_FILTER);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, newHavingFilter, this.sort, this.sortProject);
    }

    public PartialDruidQuery withAggregateProject(Project newAggregateProject) {
        this.validateStage(Stage.AGGREGATE_PROJECT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, newAggregateProject, this.havingFilter, this.sort, this.sortProject);
    }

    public PartialDruidQuery withSort(Sort newSort) {
        this.validateStage(Stage.SORT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, newSort, this.sortProject);
    }

    public PartialDruidQuery withSortProject(Project newSortProject) {
        this.validateStage(Stage.SORT_PROJECT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, newSortProject);
    }

    public RelDataType getRowType() {
        return this.leafRel().getRowType();
    }

    public RelTrait[] getRelTraits() {
        return (RelTrait[])this.leafRel().getTraitSet().toArray((Object[])new RelTrait[0]);
    }

    public DruidQuery build(DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations) {
        return DruidQuery.fromPartialQuery(this, dataSource, sourceRowSignature, plannerContext, rexBuilder, finalizeAggregations, null);
    }

    public DruidQuery build(DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations, @Nullable VirtualColumnRegistry virtualColumnRegistry) {
        return DruidQuery.fromPartialQuery(this, dataSource, sourceRowSignature, plannerContext, rexBuilder, finalizeAggregations, virtualColumnRegistry);
    }

    public boolean canAccept(Stage stage) {
        Stage currentStage = this.stage();
        if (currentStage == Stage.SELECT_PROJECT && stage == Stage.SELECT_PROJECT) {
            return true;
        }
        if (stage.compareTo(currentStage) <= 0) {
            return false;
        }
        if (stage.compareTo(Stage.AGGREGATE) > 0 && stage.compareTo(Stage.SORT) < 0 && this.aggregate == null) {
            return false;
        }
        return stage.compareTo(Stage.SORT) <= 0 || this.sort != null;
    }

    public Stage stage() {
        if (this.sortProject != null) {
            return Stage.SORT_PROJECT;
        }
        if (this.sort != null) {
            return Stage.SORT;
        }
        if (this.aggregateProject != null) {
            return Stage.AGGREGATE_PROJECT;
        }
        if (this.havingFilter != null) {
            return Stage.HAVING_FILTER;
        }
        if (this.aggregate != null) {
            return Stage.AGGREGATE;
        }
        if (this.selectProject != null) {
            return Stage.SELECT_PROJECT;
        }
        if (this.whereFilter != null) {
            return Stage.WHERE_FILTER;
        }
        return Stage.SCAN;
    }

    public RelNode leafRel() {
        Stage currentStage = this.stage();
        switch (currentStage) {
            case SORT_PROJECT: {
                return this.sortProject;
            }
            case SORT: {
                return this.sort;
            }
            case AGGREGATE_PROJECT: {
                return this.aggregateProject;
            }
            case HAVING_FILTER: {
                return this.havingFilter;
            }
            case AGGREGATE: {
                return this.aggregate;
            }
            case SELECT_PROJECT: {
                return this.selectProject;
            }
            case WHERE_FILTER: {
                return this.whereFilter;
            }
            case SCAN: {
                return this.scan;
            }
        }
        throw new ISE("Unknown stage: %s", new Object[]{currentStage});
    }

    public double estimateCost() {
        double cost = 1.0;
        if (this.getSelectProject() != null) {
            for (RexNode rexNode : this.getSelectProject().getChildExps()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        if (this.getWhereFilter() != null) {
            cost *= 0.1;
        }
        if (this.getAggregate() != null) {
            cost += 0.25 * (double)this.getAggregate().getGroupSet().size();
            cost += 0.05 * (double)this.getAggregate().getAggCallList().size();
        }
        if (this.getSort() != null) {
            if (!this.getSort().collation.getFieldCollations().isEmpty()) {
                cost *= 10.0;
            }
            if (this.getSort().fetch != null) {
                cost *= 0.5;
            }
        }
        if (this.getAggregateProject() != null) {
            for (RexNode rexNode : this.getAggregateProject().getChildExps()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        if (this.getSortProject() != null) {
            for (RexNode rexNode : this.getSortProject().getChildExps()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        return cost += 0.05 * (double)this.getRowType().getFieldCount();
    }

    private void validateStage(Stage stage) {
        if (!this.canAccept(stage)) {
            throw new ISE("Cannot move from stage[%s] to stage[%s]", new Object[]{this.stage(), stage});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialDruidQuery that = (PartialDruidQuery)o;
        return Objects.equals(this.scan, that.scan) && Objects.equals(this.whereFilter, that.whereFilter) && Objects.equals(this.selectProject, that.selectProject) && Objects.equals(this.aggregate, that.aggregate) && Objects.equals(this.havingFilter, that.havingFilter) && Objects.equals(this.aggregateProject, that.aggregateProject) && Objects.equals(this.sort, that.sort) && Objects.equals(this.sortProject, that.sortProject);
    }

    public int hashCode() {
        return Objects.hash(this.scan, this.whereFilter, this.selectProject, this.aggregate, this.havingFilter, this.aggregateProject, this.sort, this.sortProject);
    }

    public String toString() {
        return "PartialDruidQuery{scan=" + this.scan + ", whereFilter=" + this.whereFilter + ", selectProject=" + this.selectProject + ", aggregate=" + this.aggregate + ", havingFilter=" + this.havingFilter + ", aggregateProject=" + this.aggregateProject + ", sort=" + this.sort + ", sortProject=" + this.sortProject + '}';
    }

    public static enum Stage {
        SCAN,
        WHERE_FILTER,
        SELECT_PROJECT,
        AGGREGATE,
        HAVING_FILTER,
        AGGREGATE_PROJECT,
        SORT,
        SORT_PROJECT;

    }
}

