/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.Projection;
import org.apache.druid.sql.calcite.rel.Subtotals;

public class Grouping {
    private final List<DimensionExpression> dimensions;
    private final Subtotals subtotals;
    private final List<Aggregation> aggregations;
    @Nullable
    private final DimFilter havingFilter;
    private final RowSignature outputRowSignature;
    private final boolean groupingDimensionsDropped;

    private Grouping(List<DimensionExpression> dimensions, Subtotals subtotals, List<Aggregation> aggregations, @Nullable DimFilter havingFilter, RowSignature outputRowSignature) {
        this(dimensions, subtotals, aggregations, havingFilter, outputRowSignature, false);
    }

    private Grouping(List<DimensionExpression> dimensions, Subtotals subtotals, List<Aggregation> aggregations, @Nullable DimFilter havingFilter, RowSignature outputRowSignature, boolean groupingDimensionsDropped) {
        this.dimensions = ImmutableList.copyOf(dimensions);
        this.subtotals = (Subtotals)Preconditions.checkNotNull((Object)subtotals, (Object)"subtotals");
        this.aggregations = ImmutableList.copyOf(aggregations);
        this.havingFilter = havingFilter;
        this.outputRowSignature = (RowSignature)Preconditions.checkNotNull((Object)outputRowSignature, (Object)"outputRowSignature");
        this.groupingDimensionsDropped = groupingDimensionsDropped;
        HashSet<String> seen = new HashSet<String>();
        for (DimensionExpression dimensionExpression : dimensions) {
            if (seen.add(dimensionExpression.getOutputName())) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{dimensionExpression.getOutputName()});
        }
        for (Aggregation aggregation : aggregations) {
            for (AggregatorFactory aggregatorFactory : aggregation.getAggregatorFactories()) {
                if (seen.add(aggregatorFactory.getName())) continue;
                throw new ISE("Duplicate field name: %s", new Object[]{aggregatorFactory.getName()});
            }
            if (aggregation.getPostAggregator() == null || seen.add(aggregation.getPostAggregator().getName())) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{aggregation.getPostAggregator().getName()});
        }
        for (String field : outputRowSignature.getColumnNames()) {
            if (seen.contains(field)) continue;
            throw new ISE("Missing field in rowOrder: %s", new Object[]{field});
        }
    }

    private static Grouping create(List<DimensionExpression> dimensions, Subtotals subtotals, List<Aggregation> aggregations, @Nullable DimFilter havingFilter, RowSignature outputRowSignature, boolean groupingDimensionsDropped) {
        return new Grouping(dimensions, subtotals, aggregations, havingFilter, outputRowSignature, groupingDimensionsDropped);
    }

    public static Grouping create(List<DimensionExpression> dimensions, Subtotals subtotals, List<Aggregation> aggregations, @Nullable DimFilter havingFilter, RowSignature outputRowSignature) {
        return new Grouping(dimensions, subtotals, aggregations, havingFilter, outputRowSignature);
    }

    public List<DimensionExpression> getDimensions() {
        return this.dimensions;
    }

    public Subtotals getSubtotals() {
        return this.subtotals;
    }

    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public DimFilter getHavingFilter() {
        return this.havingFilter;
    }

    public List<DimensionSpec> getDimensionSpecs() {
        return this.dimensions.stream().map(DimensionExpression::toDimensionSpec).collect(Collectors.toList());
    }

    public List<AggregatorFactory> getAggregatorFactories() {
        return this.aggregations.stream().flatMap(aggregation -> aggregation.getAggregatorFactories().stream()).collect(Collectors.toList());
    }

    public List<PostAggregator> getPostAggregators() {
        return this.aggregations.stream().map(Aggregation::getPostAggregator).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public boolean hasGroupingDimensionsDropped() {
        return this.groupingDimensionsDropped;
    }

    public Grouping applyProject(PlannerContext plannerContext, Project project) {
        Subtotals newSubtotals;
        ArrayList<DimensionExpression> newDimensions = new ArrayList<DimensionExpression>();
        ArrayList<Aggregation> newAggregations = new ArrayList<Aggregation>(this.aggregations);
        Projection postAggregationProjection = Projection.postAggregation(project, plannerContext, this.outputRowSignature, "p");
        postAggregationProjection.getPostAggregators().forEach(postAggregator -> newAggregations.add(Aggregation.create(postAggregator)));
        ImmutableBitSet aggregateProjectBits = RelOptUtil.InputFinder.bits((List)project.getChildExps(), null);
        int[] newDimIndexes = new int[this.dimensions.size()];
        boolean droppedDimensions = false;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            DimensionExpression dimension = this.dimensions.get(i);
            if (Parser.parse((String)dimension.getDruidExpression().getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable()).isLiteral() && !aggregateProjectBits.get(i)) {
                droppedDimensions = true;
                newDimIndexes[i] = -1;
                continue;
            }
            newDimIndexes[i] = newDimensions.size();
            newDimensions.add(dimension);
        }
        if (newDimensions.size() != this.dimensions.size()) {
            ArrayList<IntList> newSubtotalsList = new ArrayList<IntList>();
            for (IntList subtotal : this.subtotals.getSubtotals()) {
                IntArrayList newSubtotal = new IntArrayList();
                IntListIterator intListIterator = subtotal.iterator();
                while (intListIterator.hasNext()) {
                    int dimIndex = (Integer)intListIterator.next();
                    int newDimIndex = newDimIndexes[dimIndex];
                    if (newDimIndex < 0) continue;
                    newSubtotal.add(newDimIndex);
                }
                newSubtotalsList.add((IntList)newSubtotal);
            }
            newSubtotals = new Subtotals(newSubtotalsList);
        } else {
            newSubtotals = this.subtotals;
        }
        return Grouping.create(newDimensions, newSubtotals, newAggregations, this.havingFilter, postAggregationProjection.getOutputRowSignature(), droppedDimensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grouping grouping = (Grouping)o;
        return this.dimensions.equals(grouping.dimensions) && this.subtotals.equals(grouping.subtotals) && this.aggregations.equals(grouping.aggregations) && Objects.equals(this.havingFilter, grouping.havingFilter) && this.outputRowSignature.equals((Object)grouping.outputRowSignature) && this.groupingDimensionsDropped == grouping.groupingDimensionsDropped;
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.subtotals, this.aggregations, this.havingFilter, this.outputRowSignature, this.groupingDimensionsDropped);
    }
}

