/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.joda.time.DateTimeZone;

public interface SqlStatementHandler {
    public SqlNode sqlNode();

    public void validate() throws ValidationException;

    public Set<ResourceAction> resourceActions();

    public void prepare();

    public PrepareResult prepareResult();

    public PlannerResult plan() throws ValidationException;

    public static abstract class BaseStatementHandler
    implements SqlStatementHandler {
        protected final HandlerContext handlerContext;
        protected Set<ResourceAction> resourceActions;

        protected BaseStatementHandler(HandlerContext handlerContext) {
            this.handlerContext = handlerContext;
        }

        @Override
        public Set<ResourceAction> resourceActions() {
            return this.resourceActions;
        }
    }

    public static interface HandlerContext {
        public PlannerContext plannerContext();

        public SqlEngine engine();

        public CalcitePlanner planner();

        public QueryContext queryContext();

        public Map<String, Object> queryContextMap();

        public SchemaPlus defaultSchema();

        public ObjectMapper jsonMapper();

        public DateTimeZone timeZone();
    }
}

