/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.joda.time.Period;

public class SegmentMetadataCacheConfig {
    @JsonProperty
    private boolean metadataSegmentCacheEnable = false;
    @JsonProperty
    private long metadataSegmentPollPeriod = 60000L;
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private boolean awaitInitializationOnStart = true;

    public static SegmentMetadataCacheConfig create() {
        return new SegmentMetadataCacheConfig();
    }

    public static SegmentMetadataCacheConfig create(String metadataRefreshPeriod) {
        SegmentMetadataCacheConfig config = new SegmentMetadataCacheConfig();
        config.metadataRefreshPeriod = new Period((Object)metadataRefreshPeriod);
        return config;
    }

    public boolean isMetadataSegmentCacheEnable() {
        return this.metadataSegmentCacheEnable;
    }

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public long getMetadataSegmentPollPeriod() {
        return this.metadataSegmentPollPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentMetadataCacheConfig that = (SegmentMetadataCacheConfig)o;
        return this.awaitInitializationOnStart == that.awaitInitializationOnStart && this.metadataSegmentCacheEnable == that.metadataSegmentCacheEnable && this.metadataSegmentPollPeriod == that.metadataSegmentPollPeriod && Objects.equals(this.metadataRefreshPeriod, that.metadataRefreshPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.metadataRefreshPeriod, this.awaitInitializationOnStart, this.metadataSegmentCacheEnable, this.metadataSegmentPollPeriod);
    }

    public String toString() {
        return "SegmentCacheConfig{metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", metadataSegmentCacheEnable=" + this.metadataSegmentCacheEnable + ", metadataSegmentPollPeriod=" + this.metadataSegmentPollPeriod + ", awaitInitializationOnStart=" + this.awaitInitializationOnStart + '}';
    }
}

