/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.QueryHandler;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;

public abstract class IngestHandler
extends QueryHandler {
    private static final Pattern UNNAMED_COLUMN_PATTERN = Pattern.compile("^EXPR\\$\\d+$", 2);
    @VisibleForTesting
    public static final String UNNAMED_INGESTION_COLUMN_ERROR = "Cannot ingest expressions that do not have an alias or columns with names like EXPR$[digit].\nE.g. if you are ingesting \"func(X)\", then you can rewrite it as \"func(X) as myColumn\"";
    protected final Granularity ingestionGranularity;
    protected String targetDatasource;

    IngestHandler(SqlStatementHandler.HandlerContext handlerContext, DruidSqlIngest ingestNode, SqlNode queryNode, SqlExplain explain) {
        super(handlerContext, queryNode, explain);
        this.ingestionGranularity = ingestNode.getPartitionedBy();
    }

    protected static SqlNode convertQuery(DruidSqlIngest sqlNode) throws ValidationException {
        SqlNode query = sqlNode.getSource();
        if (query instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
            SqlNodeList orderByList = sqlOrderBy.orderList;
            if (orderByList != null && !orderByList.equals(SqlNodeList.EMPTY)) {
                String opName = sqlNode.getOperator().getName();
                throw new ValidationException(StringUtils.format((String)"Cannot have ORDER BY on %s %s statement, use CLUSTERED BY instead.", (Object[])new Object[]{"INSERT".equals(opName) ? "an" : "a", opName}));
            }
        }
        if (sqlNode.getClusteredBy() != null) {
            query = DruidSqlParserUtils.convertClusterByToOrderBy(query, sqlNode.getClusteredBy());
        }
        if (!query.isA((Set)SqlKind.QUERY)) {
            throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{query.getKind()}));
        }
        return query;
    }

    protected String operationName() {
        return this.ingestNode().getOperator().getName();
    }

    protected abstract DruidSqlIngest ingestNode();

    @Override
    public void validate() throws ValidationException {
        if (this.ingestNode().getPartitionedBy() == null) {
            throw new ValidationException(StringUtils.format((String)"%s statements must specify PARTITIONED BY clause explicitly", (Object[])new Object[]{this.operationName()}));
        }
        try {
            PlannerContext plannerContext = this.handlerContext.plannerContext();
            if (this.ingestionGranularity != null) {
                plannerContext.queryContextMap().put("sqlInsertSegmentGranularity", plannerContext.getJsonMapper().writeValueAsString((Object)this.ingestionGranularity));
            }
        }
        catch (JsonProcessingException e) {
            throw new ValidationException("Unable to serialize partition granularity.");
        }
        super.validate();
        if (this.handlerContext.queryContextMap().get("sqlOuterLimit") != null) {
            throw new ValidationException(StringUtils.format((String)"%s cannot be provided with %s.", (Object[])new Object[]{"sqlOuterLimit", this.operationName()}));
        }
        this.targetDatasource = this.validateAndGetDataSourceForIngest();
        this.resourceActions.add(new ResourceAction(new Resource(this.targetDatasource, "DATASOURCE"), Action.WRITE));
    }

    @Override
    protected RelDataType returnedRowType() {
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        return this.handlerContext.engine().resultTypeForInsert(typeFactory, this.rootQueryRel.validatedRowType);
    }

    private String validateAndGetDataSourceForIngest() throws ValidationException {
        String dataSource;
        DruidSqlIngest insert = this.ingestNode();
        if (insert.isUpsert()) {
            throw new ValidationException("UPSERT is not supported.");
        }
        if (insert.getTargetColumnList() != null) {
            throw new ValidationException(this.operationName() + " with a target column list is not supported.");
        }
        SqlIdentifier tableIdentifier = (SqlIdentifier)insert.getTargetTable();
        if (tableIdentifier.names.isEmpty()) {
            throw new ValidationException(this.operationName() + " requires a target table.");
        }
        if (tableIdentifier.names.size() == 1) {
            dataSource = (String)Iterables.getOnlyElement((Iterable)tableIdentifier.names);
        } else {
            String defaultSchemaName = (String)Iterables.getOnlyElement((Iterable)CalciteSchema.from((SchemaPlus)this.handlerContext.defaultSchema()).path(null));
            if (tableIdentifier.names.size() == 2 && defaultSchemaName.equals(tableIdentifier.names.get(0))) {
                dataSource = (String)tableIdentifier.names.get(1);
            } else {
                throw new ValidationException(StringUtils.format((String)"Cannot %s into %s because it is not a Druid datasource.", (Object[])new Object[]{this.operationName(), tableIdentifier}));
            }
        }
        try {
            IdUtils.validateId((String)(this.operationName() + " dataSource"), (String)dataSource);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(e.getMessage());
        }
        return dataSource;
    }

    @Override
    protected PlannerResult planForDruid() throws ValidationException {
        return this.planWithDruidConvention();
    }

    @Override
    protected QueryMaker buildQueryMaker(RelRoot rootQueryRel) throws ValidationException {
        this.validateColumnsForIngestion(rootQueryRel);
        return this.handlerContext.engine().buildQueryMakerForInsert(this.targetDatasource, rootQueryRel, this.handlerContext.plannerContext());
    }

    private void validateColumnsForIngestion(RelRoot rootQueryRel) throws ValidationException {
        for (Pair field : rootQueryRel.fields) {
            if (!UNNAMED_COLUMN_PATTERN.matcher((CharSequence)field.right).matches()) continue;
            throw new ValidationException(UNNAMED_INGESTION_COLUMN_ERROR);
        }
    }

    protected static class ReplaceHandler
    extends IngestHandler {
        private final DruidSqlReplace sqlNode;
        private List<String> replaceIntervals;

        public ReplaceHandler(SqlStatementHandler.HandlerContext handlerContext, DruidSqlReplace sqlNode, SqlExplain explain) throws ValidationException {
            super(handlerContext, sqlNode, ReplaceHandler.convertQuery(sqlNode), explain);
            this.sqlNode = sqlNode;
        }

        @Override
        public SqlNode sqlNode() {
            return this.sqlNode;
        }

        @Override
        protected DruidSqlIngest ingestNode() {
            return this.sqlNode;
        }

        @Override
        public void validate() throws ValidationException {
            if (!this.handlerContext.plannerContext().engineHasFeature(EngineFeature.CAN_REPLACE)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute REPLACE with SQL engine '%s'.", (Object[])new Object[]{this.handlerContext.engine().name()}));
            }
            SqlNode replaceTimeQuery = this.sqlNode.getReplaceTimeQuery();
            if (replaceTimeQuery == null) {
                throw new ValidationException("Missing time chunk information in OVERWRITE clause for REPLACE. Use OVERWRITE WHERE <__time based condition> or OVERWRITE ALL to overwrite the entire table.");
            }
            this.replaceIntervals = DruidSqlParserUtils.validateQueryAndConvertToIntervals(replaceTimeQuery, this.ingestionGranularity, this.handlerContext.timeZone());
            super.validate();
            if (this.replaceIntervals != null) {
                this.handlerContext.queryContextMap().put("sqlReplaceTimeChunks", String.join((CharSequence)",", this.replaceIntervals));
            }
        }
    }

    protected static class InsertHandler
    extends IngestHandler {
        private final DruidSqlInsert sqlNode;

        public InsertHandler(SqlStatementHandler.HandlerContext handlerContext, DruidSqlInsert sqlNode, SqlExplain explain) throws ValidationException {
            super(handlerContext, sqlNode, InsertHandler.convertQuery(sqlNode), explain);
            this.sqlNode = sqlNode;
        }

        @Override
        public SqlNode sqlNode() {
            return this.sqlNode;
        }

        @Override
        protected DruidSqlIngest ingestNode() {
            return this.sqlNode;
        }

        @Override
        public void validate() throws ValidationException {
            if (!this.handlerContext.plannerContext().engineHasFeature(EngineFeature.CAN_INSERT)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute INSERT with SQL engine '%s'.", (Object[])new Object[]{this.handlerContext.engine().name()}));
            }
            super.validate();
        }
    }
}

