/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.druid.sql.calcite.external.ExternalTableScan;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.run.EngineFeature;

public class ExternalTableScanRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public ExternalTableScanRule(PlannerContext plannerContext) {
        super(ExternalTableScanRule.operand(ExternalTableScan.class, (RelOptRuleOperandChildren)ExternalTableScanRule.any()));
        this.plannerContext = plannerContext;
    }

    public boolean matches(RelOptRuleCall call) {
        if (this.plannerContext.engineHasFeature(EngineFeature.READ_EXTERNAL_DATA)) {
            return super.matches(call);
        }
        this.plannerContext.setPlanningError("Cannot use '%s' with SQL engine '%s'.", "EXTERN", this.plannerContext.getEngine().name());
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        if (!this.plannerContext.engineHasFeature(EngineFeature.READ_EXTERNAL_DATA)) {
            throw new UnsupportedOperationException();
        }
        ExternalTableScan scan = (ExternalTableScan)call.rel(0);
        call.transformTo((RelNode)DruidQueryRel.scanExternal(scan, this.plannerContext));
    }
}

