/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class ComplexDecodeBase64OperatorConversion
implements SqlOperatorConversion {
    public static final SqlReturnTypeInference ARBITRARY_COMPLEX_RETURN_TYPE_INFERENCE = opBinding -> {
        String typeName = (String)opBinding.getOperandLiteralValue(0, String.class);
        return RowSignatures.makeComplexType(opBinding.getTypeFactory(), ColumnType.ofComplex((String)typeName), true);
    };
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"complex_decode_base64")).operandTypeChecker(OperandTypes.sequence((String)"(typeName,base64)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.LITERAL}), OperandTypes.ANY})).returnTypeInference(ARBITRARY_COMPLEX_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            String arg0 = ((DruidExpression)druidExpressions.get(0)).getExpression();
            return DruidExpression.ofExpression(ColumnType.ofComplex((String)arg0.substring(1, arg0.length() - 1)), DruidExpression.functionCall("complex_decode_base64"), druidExpressions);
        });
    }
}

