/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.Period;

public class CastOperatorConversion
implements SqlOperatorConversion {
    private static final Map<SqlTypeName, ExprType> EXPRESSION_TYPES;

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CAST;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        ExprType toExprType;
        RexNode operand = (RexNode)((RexCall)rexNode).getOperands().get(0);
        DruidExpression operandExpression = Expressions.toDruidExpression(plannerContext, rowSignature, operand);
        if (operandExpression == null) {
            return null;
        }
        SqlTypeName fromType = operand.getType().getSqlTypeName();
        SqlTypeName toType = rexNode.getType().getSqlTypeName();
        if (SqlTypeName.CHAR_TYPES.contains(fromType) && SqlTypeName.DATETIME_TYPES.contains(toType)) {
            return CastOperatorConversion.castCharToDateTime(plannerContext, operandExpression, toType, Calcites.getColumnTypeForRelDataType(rexNode.getType()));
        }
        if (SqlTypeName.DATETIME_TYPES.contains(fromType) && SqlTypeName.CHAR_TYPES.contains(toType)) {
            return CastOperatorConversion.castDateTimeToChar(plannerContext, operandExpression, fromType, Calcites.getColumnTypeForRelDataType(rexNode.getType()));
        }
        ExprType fromExprType = SqlTypeName.ANY.equals((Object)fromType) ? EXPRESSION_TYPES.get(toType) : EXPRESSION_TYPES.get(fromType);
        ExprType exprType = toExprType = SqlTypeName.ANY.equals((Object)toType) ? EXPRESSION_TYPES.get(fromType) : EXPRESSION_TYPES.get(toType);
        if (fromExprType == null || toExprType == null) {
            return null;
        }
        DruidExpression typeCastExpression = fromExprType != toExprType ? operandExpression.map(Function.identity(), expression -> StringUtils.format((String)"CAST(%s, '%s')", (Object[])new Object[]{expression, toExprType.toString()})) : operandExpression;
        if (toType == SqlTypeName.DATE) {
            return TimeFloorOperatorConversion.applyTimestampFloor(typeCastExpression, new PeriodGranularity(Period.days((int)1), null, plannerContext.getTimeZone()), plannerContext.getExprMacroTable());
        }
        return typeCastExpression;
    }

    private static DruidExpression castCharToDateTime(PlannerContext plannerContext, DruidExpression operand, SqlTypeName toType, ColumnType toDruidType) {
        DruidExpression timestampExpression = DruidExpression.ofFunctionCall(toDruidType, "timestamp_parse", (List<DruidExpression>)ImmutableList.of((Object)operand, (Object)DruidExpression.ofLiteral(null, DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral(plannerContext.getTimeZone().getID())));
        if (toType == SqlTypeName.DATE) {
            return TimeFloorOperatorConversion.applyTimestampFloor(timestampExpression, new PeriodGranularity(Period.days((int)1), null, plannerContext.getTimeZone()), plannerContext.getExprMacroTable());
        }
        if (toType == SqlTypeName.TIMESTAMP) {
            return timestampExpression;
        }
        throw new ISE("Unsupported DateTime type[%s]", new Object[]{toType});
    }

    private static DruidExpression castDateTimeToChar(PlannerContext plannerContext, DruidExpression operand, SqlTypeName fromType, ColumnType toDruidType) {
        return DruidExpression.ofFunctionCall(toDruidType, "timestamp_format", (List<DruidExpression>)ImmutableList.of((Object)operand, (Object)DruidExpression.ofStringLiteral(CastOperatorConversion.dateTimeFormatString(fromType)), (Object)DruidExpression.ofStringLiteral(plannerContext.getTimeZone().getID())));
    }

    private static String dateTimeFormatString(SqlTypeName sqlTypeName) {
        if (sqlTypeName == SqlTypeName.DATE) {
            return "yyyy-MM-dd";
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        throw new ISE("Unsupported DateTime type[%s]", new Object[]{sqlTypeName});
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SqlTypeName type : SqlTypeName.FRACTIONAL_TYPES) {
            builder.put((Object)type, (Object)ExprType.DOUBLE);
        }
        for (SqlTypeName type : SqlTypeName.INT_TYPES) {
            builder.put((Object)type, (Object)ExprType.LONG);
        }
        for (SqlTypeName type : SqlTypeName.STRING_TYPES) {
            builder.put((Object)type, (Object)ExprType.STRING);
        }
        builder.put((Object)SqlTypeName.BOOLEAN, (Object)ExprType.LONG);
        builder.put((Object)SqlTypeName.TIMESTAMP, (Object)ExprType.LONG);
        builder.put((Object)SqlTypeName.DATE, (Object)ExprType.LONG);
        for (SqlTypeName type : SqlTypeName.DAY_INTERVAL_TYPES) {
            builder.put((Object)type, (Object)ExprType.LONG);
        }
        for (SqlTypeName type : SqlTypeName.YEAR_INTERVAL_TYPES) {
            builder.put((Object)type, (Object)ExprType.LONG);
        }
        EXPRESSION_TYPES = builder.build();
    }
}

