/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.BaseExpressionDimFilterOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayOverlapOperatorConversion
extends BaseExpressionDimFilterOperatorConversion {
    private static final String EXPR_FUNCTION = "array_overlap";
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("ARRAY_OVERLAP").operandTypeChecker(OperandTypes.sequence((String)"(array,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).returnTypeInference(ReturnTypes.BOOLEAN).build();

    public ArrayOverlapOperatorConversion() {
        super((SqlOperator)SQL_FUNCTION, EXPR_FUNCTION);
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        DruidExpression complexExpr;
        DruidExpression simpleExtractionExpr;
        boolean rightSimpleExtractionExpr;
        List operands = ((RexCall)rexNode).getOperands();
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, operands);
        if (druidExpressions == null) {
            return null;
        }
        boolean leftSimpleExtractionExpr = druidExpressions.get(0).isSimpleExtraction();
        if (leftSimpleExtractionExpr ^ (rightSimpleExtractionExpr = druidExpressions.get(1).isSimpleExtraction())) {
            if (leftSimpleExtractionExpr) {
                simpleExtractionExpr = druidExpressions.get(0);
                complexExpr = druidExpressions.get(1);
            } else {
                simpleExtractionExpr = druidExpressions.get(1);
                complexExpr = druidExpressions.get(0);
            }
        } else {
            return ArrayOverlapOperatorConversion.toExpressionFilter(plannerContext, this.getDruidFunctionName(), druidExpressions);
        }
        Expr expr = Parser.parse((String)complexExpr.getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
        if (expr.isLiteral()) {
            ExprEval exprEval = expr.eval(InputBindings.nilBindings());
            Object[] arrayElements = exprEval.asArray();
            if (arrayElements == null || arrayElements.length == 0) {
                return null;
            }
            if (arrayElements.length == 1) {
                return ArrayOverlapOperatorConversion.newSelectorDimFilter(simpleExtractionExpr.getSimpleExtraction(), Evals.asString((Object)arrayElements[0]));
            }
            return new InDimFilter(simpleExtractionExpr.getSimpleExtraction().getColumn(), new InDimFilter.ValuesSet((Collection)Arrays.stream(arrayElements).map(Evals::asString).collect(Collectors.toList())), simpleExtractionExpr.getSimpleExtraction().getExtractionFn(), null);
        }
        return ArrayOverlapOperatorConversion.toExpressionFilter(plannerContext, this.getDruidFunctionName(), druidExpressions);
    }
}

