/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.BaseExpressionDimFilterOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayContainsOperatorConversion
extends BaseExpressionDimFilterOperatorConversion {
    private static final String EXPR_FUNCTION = "array_contains";
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("ARRAY_CONTAINS").operandTypeChecker(OperandTypes.sequence((String)"(array,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).returnTypeInference(ReturnTypes.BOOLEAN).build();

    public ArrayContainsOperatorConversion() {
        super((SqlOperator)SQL_FUNCTION, EXPR_FUNCTION);
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        Expr expr;
        List operands = ((RexCall)rexNode).getOperands();
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, operands);
        if (druidExpressions == null) {
            return null;
        }
        DruidExpression leftExpr = druidExpressions.get(0);
        DruidExpression rightExpr = druidExpressions.get(1);
        if (leftExpr.isSimpleExtraction() && (expr = Parser.parse((String)rightExpr.getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable())).isLiteral()) {
            ExprEval exprEval = expr.eval(InputBindings.nilBindings());
            Object[] arrayElements = exprEval.asArray();
            if (arrayElements == null || arrayElements.length == 0) {
                return null;
            }
            if (arrayElements.length == 1) {
                return ArrayContainsOperatorConversion.newSelectorDimFilter(leftExpr.getSimpleExtraction(), Evals.asString((Object)arrayElements[0]));
            }
            List selectFilters = Arrays.stream(arrayElements).map(val -> ArrayContainsOperatorConversion.newSelectorDimFilter(leftExpr.getSimpleExtraction(), Evals.asString((Object)val))).collect(Collectors.toList());
            return new AndDimFilter(selectFilters);
        }
        return ArrayContainsOperatorConversion.toExpressionFilter(plannerContext, this.getDruidFunctionName(), druidExpressions);
    }
}

