/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.EarliestLatestAnySqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class EarliestLatestBySqlAggregator
implements SqlAggregator {
    public static final SqlAggregator EARLIEST_BY = new EarliestLatestBySqlAggregator(EarliestLatestAnySqlAggregator.AggregatorType.EARLIEST);
    public static final SqlAggregator LATEST_BY = new EarliestLatestBySqlAggregator(EarliestLatestAnySqlAggregator.AggregatorType.LATEST);
    private final EarliestLatestAnySqlAggregator.AggregatorType aggregatorType;
    private final SqlAggFunction function;

    private EarliestLatestBySqlAggregator(EarliestLatestAnySqlAggregator.AggregatorType aggregatorType) {
        this.aggregatorType = aggregatorType;
        this.function = new EarliestByLatestBySqlAggFunction(aggregatorType);
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        AggregatorFactory theAggFactory;
        List<RexNode> rexNodes = aggregateCall.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).collect(Collectors.toList());
        List<DruidExpression> args = Expressions.toDruidExpressions(plannerContext, rowSignature, rexNodes);
        if (args == null) {
            return null;
        }
        String aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        ColumnType outputType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (outputType == null) {
            throw new ISE("Cannot translate output sqlTypeName[%s] to Druid type for aggregator[%s]", new Object[]{aggregateCall.getType().getSqlTypeName(), aggregateCall.getName()});
        }
        String fieldName = EarliestLatestAnySqlAggregator.getColumnName(plannerContext, virtualColumnRegistry, args.get(0), rexNodes.get(0));
        switch (args.size()) {
            case 2: {
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, EarliestLatestAnySqlAggregator.getColumnName(plannerContext, virtualColumnRegistry, args.get(1), rexNodes.get(1)), outputType, -1);
                break;
            }
            case 3: {
                int maxStringBytes;
                try {
                    maxStringBytes = RexLiteral.intValue((RexNode)rexNodes.get(2));
                }
                catch (AssertionError ae) {
                    plannerContext.setPlanningError("The third argument '%s' to function '%s' is not a number", rexNodes.get(2), aggregateCall.getName());
                    return null;
                }
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, EarliestLatestAnySqlAggregator.getColumnName(plannerContext, virtualColumnRegistry, args.get(1), rexNodes.get(1)), outputType, maxStringBytes);
                break;
            }
            default: {
                throw new IAE("aggregation[%s], Invalid number of arguments[%,d] to [%s] operator", new Object[]{aggregatorName, args.size(), this.aggregatorType.name()});
            }
        }
        return Aggregation.create(Collections.singletonList(theAggFactory), (PostAggregator)(finalizeAggregations ? new FinalizingFieldAccessPostAggregator(name, aggregatorName) : null));
    }

    private static class EarliestByLatestBySqlAggFunction
    extends SqlAggFunction {
        private static final SqlReturnTypeInference EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE = new EarliestLatestAnySqlAggregator.EarliestLatestReturnTypeInference(0);

        EarliestByLatestBySqlAggFunction(EarliestLatestAnySqlAggregator.AggregatorType aggregatorType) {
            super(StringUtils.format((String)"%s_BY", (Object[])new Object[]{aggregatorType.name()}), null, SqlKind.OTHER_FUNCTION, EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE, InferTypes.RETURN_TYPE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)("'" + aggregatorType.name() + "(expr, timeColumn)'\n"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP})}), OperandTypes.sequence((String)("'" + aggregatorType.name() + "(expr, timeColumn, maxBytesPerString)'\n"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP}), OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.NUMERIC, OperandTypes.LITERAL})})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }
}

