/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class BuiltinApproxCountDistinctSqlAggregator
implements SqlAggregator {
    public static final String NAME = "APPROX_COUNT_DISTINCT_BUILTIN";
    private static final SqlAggFunction FUNCTION_INSTANCE = new BuiltinApproxCountDistinctSqlAggFunction();

    @Override
    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        Object aggregatorFactory;
        String aggregatorName;
        RexNode rexNode = Expressions.fromFieldAccess(rowSignature, project, (Integer)Iterables.getOnlyElement((Iterable)aggregateCall.getArgList()));
        DruidExpression arg = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        if (arg == null) {
            return null;
        }
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        if (arg.isDirectColumnAccess() && rowSignature.getColumnType(arg.getDirectColumn()).map(type -> type.is((TypeDescriptor)ValueType.COMPLEX)).orElse(false).booleanValue()) {
            aggregatorFactory = new HyperUniquesAggregatorFactory(aggregatorName, arg.getDirectColumn(), false, true);
        } else {
            DimensionSpec dimensionSpec;
            RelDataType dataType = rexNode.getType();
            ColumnType inputType = Calcites.getColumnTypeForRelDataType(dataType);
            if (inputType == null) {
                throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{dataType.getSqlTypeName(), aggregatorName});
            }
            if (arg.isSimpleExtraction()) {
                dimensionSpec = arg.getSimpleExtraction().toDimensionSpec(null, inputType);
            } else {
                String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, dataType);
                dimensionSpec = new DefaultDimensionSpec(virtualColumnName, null, inputType);
            }
            aggregatorFactory = inputType.is((TypeDescriptor)ValueType.COMPLEX) ? new HyperUniquesAggregatorFactory(aggregatorName, dimensionSpec.getOutputName(), false, true) : new CardinalityAggregatorFactory(aggregatorName, null, (List)ImmutableList.of((Object)dimensionSpec), false, true);
        }
        return Aggregation.create(Collections.singletonList(aggregatorFactory), (PostAggregator)(finalizeAggregations ? new HyperUniqueFinalizingPostAggregator(name, aggregatorFactory.getName()) : null));
    }

    private static class BuiltinApproxCountDistinctSqlAggFunction
    extends SqlAggFunction {
        BuiltinApproxCountDistinctSqlAggFunction() {
            super(BuiltinApproxCountDistinctSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), InferTypes.VARCHAR_1024, (SqlOperandTypeChecker)OperandTypes.ANY, SqlFunctionCategory.STRING, false, false, Optionality.FORBIDDEN);
        }
    }
}

