/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchConnectionException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.AvaticaRuntimeException;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidConnection;
import org.apache.druid.sql.avatica.DruidJdbcPreparedStatement;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;
import org.apache.druid.sql.avatica.DruidJdbcStatement;
import org.apache.druid.sql.avatica.ErrorHandler;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

@LazySingleton
public class DruidMeta
extends MetaImpl {
    private static final Logger LOG = new Logger(DruidMeta.class);
    private static final Set<String> SENSITIVE_CONTEXT_FIELDS = ImmutableSet.of((Object)"user", (Object)"password");
    private final SqlStatementFactory sqlStatementFactory;
    private final ScheduledExecutorService exec;
    private final AvaticaServerConfig config;
    private final List<Authenticator> authenticators;
    private final ErrorHandler errorHandler;
    private final DruidJdbcResultSet.ResultFetcherFactory fetcherFactory;
    private final ConcurrentMap<String, DruidConnection> connections = new ConcurrentHashMap<String, DruidConnection>();
    private final AtomicInteger connectionCount = new AtomicInteger();

    public static <T extends Throwable> T logFailure(T error, String message, Object ... format) {
        LOG.error(error, message, format);
        return error;
    }

    public static <T extends Throwable> T logFailure(T error) {
        if (error instanceof NoSuchConnectionException) {
            NoSuchConnectionException ex = (NoSuchConnectionException)error;
            DruidMeta.logFailure(error, "No such connection: %s", ex.getConnectionId());
        } else if (error instanceof NoSuchStatementException) {
            NoSuchStatementException ex = (NoSuchStatementException)error;
            DruidMeta.logFailure(error, "No such statement: %s, %d", ex.getStatementHandle().connectionId, ex.getStatementHandle().id);
        } else {
            DruidMeta.logFailure(error, error.getMessage(), new Object[0]);
        }
        return error;
    }

    @Inject
    public DruidMeta(@NativeQuery SqlStatementFactory sqlStatementFactory, AvaticaServerConfig config, ErrorHandler errorHandler, AuthenticatorMapper authMapper) {
        this(sqlStatementFactory, config, errorHandler, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("DruidMeta-ScheduledExecutor-%d").setDaemon(true).build()), authMapper.getAuthenticatorChain(), new DruidJdbcResultSet.ResultFetcherFactory(config.getFetchTimeoutMs()));
    }

    public DruidMeta(SqlStatementFactory sqlStatementFactory, AvaticaServerConfig config, ErrorHandler errorHandler, ScheduledExecutorService exec, List<Authenticator> authenticators, DruidJdbcResultSet.ResultFetcherFactory fetcherFactory) {
        super(null);
        this.sqlStatementFactory = sqlStatementFactory;
        this.config = config;
        this.errorHandler = errorHandler;
        this.exec = exec;
        this.authenticators = authenticators;
        this.fetcherFactory = fetcherFactory;
    }

    public void openConnection(Meta.ConnectionHandle ch, Map<String, String> info) {
        HashMap<String, Object> secret = new HashMap<String, Object>();
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (info != null) {
            for (Map.Entry<String, String> entry : info.entrySet()) {
                if (SENSITIVE_CONTEXT_FIELDS.contains(entry.getKey())) {
                    secret.put(entry.getKey(), entry.getValue());
                    continue;
                }
                contextMap.put(entry.getKey(), entry.getValue());
            }
        }
        contextMap.put("sqlStringifyArrays", false);
        try {
            this.openDruidConnection(ch.id, secret, contextMap);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public void closeConnection(Meta.ConnectionHandle ch) {
        try {
            DruidConnection druidConnection = (DruidConnection)this.connections.remove(ch.id);
            if (druidConnection != null) {
                this.connectionCount.decrementAndGet();
                druidConnection.close();
            }
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        try {
            this.getDruidConnection(ch.id);
            return connProps;
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        try {
            DruidJdbcStatement druidStatement = this.getDruidConnection(ch.id).createStatement(this.sqlStatementFactory, this.fetcherFactory);
            return new Meta.StatementHandle(ch.id, druidStatement.getStatementId(), null);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        try {
            DruidConnection druidConnection = this.getDruidConnection(ch.id);
            SqlQueryPlus sqlReq = new SqlQueryPlus(sql, druidConnection.sessionContext(), null, this.doAuthenticate(druidConnection));
            DruidJdbcPreparedStatement stmt = this.getDruidConnection(ch.id).createPreparedStatement(this.sqlStatementFactory, sqlReq, maxRowCount, this.fetcherFactory);
            stmt.prepare();
            LOG.debug("Successfully prepared statement [%s] for execution", new Object[]{stmt.getStatementId()});
            return new Meta.StatementHandle(ch.id, stmt.getStatementId(), stmt.getSignature());
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    private AuthenticationResult doAuthenticate(DruidConnection druidConnection) {
        AuthenticationResult authenticationResult = this.authenticateConnection(druidConnection);
        if (authenticationResult != null) {
            return authenticationResult;
        }
        throw DruidMeta.logFailure(new AvaticaRuntimeException("Unauthorized", 2, "00002", AvaticaSeverity.ERROR), "Authentication failed for prepare", new Object[0]);
    }

    @Deprecated
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, Meta.PrepareCallback callback) {
        throw this.errorHandler.sanitize(new UOE("Deprecated", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle statement, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) {
        try {
            DruidConnection druidConnection;
            DruidJdbcStatement druidStatement = this.getDruidStatement(statement, DruidJdbcStatement.class);
            DruidConnection druidConnection2 = druidConnection = this.getDruidConnection(statement.connectionId);
            synchronized (druidConnection2) {
                AuthenticationResult authenticationResult = this.doAuthenticate(druidConnection);
                SqlQueryPlus sqlRequest = SqlQueryPlus.builder(sql).auth(authenticationResult).build();
                druidStatement.execute(sqlRequest, maxRowCount);
                Meta.ExecuteResult result = this.doFetch(druidStatement, maxRowsInFirstFrame);
                LOG.debug("Successfully prepared statement [%s] and started execution", new Object[]{druidStatement.getStatementId()});
                return result;
            }
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    private RuntimeException mapException(Throwable t) {
        if (t instanceof AvaticaRuntimeException) {
            throw (AvaticaRuntimeException)t;
        }
        if (t instanceof NoSuchConnectionException) {
            throw (NoSuchConnectionException)t;
        }
        String className = t.getClass().getSimpleName();
        if (t instanceof ForbiddenException || "BasicSecurityAuthenticationException".equals(className)) {
            throw new AvaticaRuntimeException(t.getMessage(), 2, "00002", AvaticaSeverity.ERROR);
        }
        throw this.errorHandler.sanitize(t);
    }

    private Meta.ExecuteResult doFetch(AbstractDruidJdbcStatement druidStatement, int maxRows) {
        Meta.Signature signature = druidStatement.getSignature();
        Meta.Frame firstFrame = druidStatement.nextFrame(0L, this.getEffectiveMaxRowsPerFrame(maxRows));
        return new Meta.ExecuteResult((List)ImmutableList.of((Object)Meta.MetaResultSet.create((String)druidStatement.connectionId, (int)druidStatement.statementId, (boolean)false, (Meta.Signature)signature, (Meta.Frame)firstFrame)));
    }

    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle statement, List<String> sqlCommands) {
        throw this.errorHandler.sanitize(new UOE("Batch statements not supported", new Object[0]));
    }

    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle statement, List<List<TypedValue>> parameterValues) {
        throw this.errorHandler.sanitize(new UOE("Batch statements not supported", new Object[0]));
    }

    public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        try {
            int maxRows = this.getEffectiveMaxRowsPerFrame(fetchMaxRowCount);
            LOG.debug("Fetching next frame from offset %,d with %,d rows for statement [%s]", new Object[]{offset, maxRows, statement.id});
            return this.getDruidStatement(statement, AbstractDruidJdbcStatement.class).nextFrame(offset, maxRows);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    @Deprecated
    public Meta.ExecuteResult execute(Meta.StatementHandle statement, List<TypedValue> parameterValues, long maxRowCount) {
        throw this.errorHandler.sanitize(new UOE("Deprecated", new Object[0]));
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle statement, List<TypedValue> parameterValues, int maxRowsInFirstFrame) {
        try {
            DruidJdbcPreparedStatement druidStatement = this.getDruidStatement(statement, DruidJdbcPreparedStatement.class);
            druidStatement.execute(parameterValues);
            Meta.ExecuteResult result = this.doFetch(druidStatement, maxRowsInFirstFrame);
            LOG.debug("Successfully started execution of statement [%s]", new Object[]{druidStatement.getStatementId()});
            return result;
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Iterable<Object> createIterable(Meta.StatementHandle statement, QueryState state, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        return null;
    }

    public void closeStatement(Meta.StatementHandle h) {
        try {
            DruidConnection druidConnection = (DruidConnection)this.connections.get(h.connectionId);
            if (druidConnection != null) {
                druidConnection.closeStatement(h.id);
            }
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public boolean syncResults(Meta.StatementHandle sh, QueryState state, long offset) {
        try {
            AbstractDruidJdbcStatement druidStatement = this.getDruidStatement(sh, AbstractDruidJdbcStatement.class);
            boolean isDone = druidStatement.isDone();
            long currentOffset = druidStatement.getCurrentOffset();
            if (currentOffset != offset) {
                throw DruidMeta.logFailure(new ISE("Requested offset %,d does not match currentOffset %,d", new Object[]{offset, currentOffset}));
            }
            return !isDone;
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public void commit(Meta.ConnectionHandle ch) {
    }

    public void rollback(Meta.ConnectionHandle ch) {
    }

    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        return ImmutableMap.of();
    }

    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        try {
            String sql = "SELECT\n  DISTINCT CATALOG_NAME AS TABLE_CAT\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\nORDER BY\n  TABLE_CAT\n";
            return this.sqlResultSet(ch, "SELECT\n  DISTINCT CATALOG_NAME AS TABLE_CAT\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\nORDER BY\n  TABLE_CAT\n");
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        try {
            ArrayList<String> whereBuilder = new ArrayList<String>();
            if (catalog != null) {
                whereBuilder.add("SCHEMATA.CATALOG_NAME = " + Calcites.escapeStringLiteral(catalog));
            }
            if (schemaPattern.s != null) {
                whereBuilder.add("SCHEMATA.SCHEMA_NAME LIKE " + DruidMeta.withEscapeClause(schemaPattern.s));
            }
            String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
            String sql = "SELECT\n  SCHEMA_NAME AS TABLE_SCHEM,\n  CATALOG_NAME AS TABLE_CATALOG\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\n" + where + "\nORDER BY\n  TABLE_CATALOG, TABLE_SCHEM\n";
            return this.sqlResultSet(ch, sql);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        try {
            ArrayList<String> whereBuilder = new ArrayList<String>();
            if (catalog != null) {
                whereBuilder.add("TABLES.TABLE_CATALOG = " + Calcites.escapeStringLiteral(catalog));
            }
            if (schemaPattern.s != null) {
                whereBuilder.add("TABLES.TABLE_SCHEMA LIKE " + DruidMeta.withEscapeClause(schemaPattern.s));
            }
            if (tableNamePattern.s != null) {
                whereBuilder.add("TABLES.TABLE_NAME LIKE " + DruidMeta.withEscapeClause(tableNamePattern.s));
            }
            if (typeList != null) {
                ArrayList<String> escapedTypes = new ArrayList<String>();
                for (String type : typeList) {
                    escapedTypes.add(Calcites.escapeStringLiteral(type));
                }
                whereBuilder.add("TABLES.TABLE_TYPE IN (" + Joiner.on((String)", ").join(escapedTypes) + ")");
            }
            String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
            String sql = "SELECT\n  TABLE_CATALOG AS TABLE_CAT,\n  TABLE_SCHEMA AS TABLE_SCHEM,\n  TABLE_NAME AS TABLE_NAME,\n  TABLE_TYPE AS TABLE_TYPE,\n  CAST(NULL AS VARCHAR) AS REMARKS,\n  CAST(NULL AS VARCHAR) AS TYPE_CAT,\n  CAST(NULL AS VARCHAR) AS TYPE_SCHEM,\n  CAST(NULL AS VARCHAR) AS TYPE_NAME,\n  CAST(NULL AS VARCHAR) AS SELF_REFERENCING_COL_NAME,\n  CAST(NULL AS VARCHAR) AS REF_GENERATION\nFROM\n  INFORMATION_SCHEMA.TABLES\n" + where + "\nORDER BY\n  TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME\n";
            return this.sqlResultSet(ch, sql);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        try {
            ArrayList<String> whereBuilder = new ArrayList<String>();
            if (catalog != null) {
                whereBuilder.add("COLUMNS.TABLE_CATALOG = " + Calcites.escapeStringLiteral(catalog));
            }
            if (schemaPattern.s != null) {
                whereBuilder.add("COLUMNS.TABLE_SCHEMA LIKE " + DruidMeta.withEscapeClause(schemaPattern.s));
            }
            if (tableNamePattern.s != null) {
                whereBuilder.add("COLUMNS.TABLE_NAME LIKE " + DruidMeta.withEscapeClause(tableNamePattern.s));
            }
            if (columnNamePattern.s != null) {
                whereBuilder.add("COLUMNS.COLUMN_NAME LIKE " + DruidMeta.withEscapeClause(columnNamePattern.s));
            }
            String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
            String sql = "SELECT\n  TABLE_CATALOG AS TABLE_CAT,\n  TABLE_SCHEMA AS TABLE_SCHEM,\n  TABLE_NAME AS TABLE_NAME,\n  COLUMN_NAME AS COLUMN_NAME,\n  CAST(JDBC_TYPE AS INTEGER) AS DATA_TYPE,\n  DATA_TYPE AS TYPE_NAME,\n  -1 AS COLUMN_SIZE,\n  -1 AS BUFFER_LENGTH,\n  -1 AS DECIMAL_DIGITS,\n  -1 AS NUM_PREC_RADIX,\n  CASE IS_NULLABLE WHEN 'YES' THEN 1 ELSE 0 END AS NULLABLE,\n  CAST(NULL AS VARCHAR) AS REMARKS,\n  COLUMN_DEFAULT AS COLUMN_DEF,\n  -1 AS SQL_DATA_TYPE,\n  -1 AS SQL_DATETIME_SUB,\n  -1 AS CHAR_OCTET_LENGTH,\n  CAST(ORDINAL_POSITION AS INTEGER) AS ORDINAL_POSITION,\n  IS_NULLABLE AS IS_NULLABLE,\n  CAST(NULL AS VARCHAR) AS SCOPE_CATALOG,\n  CAST(NULL AS VARCHAR) AS SCOPE_SCHEMA,\n  CAST(NULL AS VARCHAR) AS SCOPE_TABLE,\n  -1 AS SOURCE_DATA_TYPE,\n  'NO' AS IS_AUTOINCREMENT,\n  'NO' AS IS_GENERATEDCOLUMN\nFROM\n  INFORMATION_SCHEMA.COLUMNS\n" + where + "\nORDER BY\n  TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION\n";
            return this.sqlResultSet(ch, sql);
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        try {
            String sql = "SELECT\n  DISTINCT TABLE_TYPE AS TABLE_TYPE\nFROM\n  INFORMATION_SCHEMA.TABLES\nORDER BY\n  TABLE_TYPE\n";
            return this.sqlResultSet(ch, "SELECT\n  DISTINCT TABLE_TYPE AS TABLE_TYPE\nFROM\n  INFORMATION_SCHEMA.TABLES\nORDER BY\n  TABLE_TYPE\n");
        }
        catch (Throwable t) {
            throw this.mapException(t);
        }
    }

    @VisibleForTesting
    void closeAllConnections() {
        for (String connectionId : ImmutableSet.copyOf(this.connections.keySet())) {
            this.closeConnection(new Meta.ConnectionHandle(connectionId));
        }
    }

    @Nullable
    private AuthenticationResult authenticateConnection(DruidConnection connection) {
        Map<String, Object> context = connection.userSecret();
        for (Authenticator authenticator : this.authenticators) {
            LOG.debug("Attempting authentication with authenticator [%s]", new Object[]{authenticator.getClass()});
            AuthenticationResult authenticationResult = authenticator.authenticateJDBCContext(context);
            if (authenticationResult == null) continue;
            LOG.debug("Authenticated identity [%s] for connection [%s]", new Object[]{authenticationResult.getIdentity(), connection.getConnectionId()});
            return authenticationResult;
        }
        LOG.debug("No successful authentication", new Object[0]);
        return null;
    }

    private DruidConnection openDruidConnection(String connectionId, Map<String, Object> userSecret, Map<String, Object> context) {
        DruidConnection putResult;
        if (this.connectionCount.incrementAndGet() > this.config.getMaxConnections()) {
            Iterator entryIterator = this.connections.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                if (!((DruidConnection)entry.getValue()).closeIfEmpty()) continue;
                entryIterator.remove();
                this.connectionCount.decrementAndGet();
                break;
            }
            if (this.connectionCount.get() > this.config.getMaxConnections()) {
                this.connectionCount.decrementAndGet();
                throw DruidMeta.logFailure(new ISE("Too many connections", new Object[0]), "Too many connections, limit is %,d per broker", this.config.getMaxConnections());
            }
        }
        if ((putResult = this.connections.putIfAbsent(connectionId, new DruidConnection(connectionId, this.config.getMaxStatementsPerConnection(), userSecret, context))) != null) {
            this.connectionCount.decrementAndGet();
            throw DruidMeta.logFailure(new ISE("Connection [%s] already open.", new Object[]{connectionId}));
        }
        LOG.debug("Connection [%s] opened.", new Object[]{connectionId});
        return this.getDruidConnection(connectionId);
    }

    @Nonnull
    private DruidConnection getDruidConnection(String connectionId) {
        DruidConnection connection = (DruidConnection)this.connections.get(connectionId);
        if (connection == null) {
            throw DruidMeta.logFailure(new NoSuchConnectionException(connectionId));
        }
        return connection.sync(this.exec.schedule(() -> {
            LOG.debug("Connection [%s] timed out.", new Object[]{connectionId});
            this.closeConnection(new Meta.ConnectionHandle(connectionId));
        }, new Interval((ReadableInstant)DateTimes.nowUtc(), (ReadablePeriod)this.config.getConnectionIdleTimeout()).toDurationMillis(), TimeUnit.MILLISECONDS));
    }

    @Nonnull
    private <T extends AbstractDruidJdbcStatement> T getDruidStatement(Meta.StatementHandle statement, Class<T> stmtClass) throws NoSuchStatementException {
        DruidConnection connection = this.getDruidConnection(statement.connectionId);
        AbstractDruidJdbcStatement druidStatement = connection.getStatement(statement.id);
        if (druidStatement == null) {
            throw DruidMeta.logFailure(new NoSuchStatementException(statement));
        }
        try {
            return (T)((AbstractDruidJdbcStatement)stmtClass.cast(druidStatement));
        }
        catch (ClassCastException e) {
            throw DruidMeta.logFailure(new NoSuchStatementException(statement));
        }
    }

    private Meta.MetaResultSet sqlResultSet(Meta.ConnectionHandle ch, String sql) {
        Meta.StatementHandle statement = this.createStatement(ch);
        try {
            Meta.ExecuteResult result = this.prepareAndExecute(statement, sql, -1L, -1, null);
            Meta.MetaResultSet metaResultSet = (Meta.MetaResultSet)Iterables.getOnlyElement((Iterable)result.resultSets);
            if (!metaResultSet.firstFrame.done) {
                throw new ISE("Expected all results to be in a single frame!", new Object[0]);
            }
            Meta.MetaResultSet metaResultSet2 = metaResultSet;
            return metaResultSet2;
        }
        catch (Exception e) {
            throw DruidMeta.logFailure(new RuntimeException(e));
        }
        finally {
            this.closeStatement(statement);
        }
    }

    private int getEffectiveMaxRowsPerFrame(int clientMaxRowsPerFrame) {
        if (this.config.getMaxRowsPerFrame() < 0) {
            return this.adjustForMinumumRowsPerFrame(clientMaxRowsPerFrame);
        }
        if (clientMaxRowsPerFrame < 0) {
            return this.adjustForMinumumRowsPerFrame(this.config.getMaxRowsPerFrame());
        }
        return this.adjustForMinumumRowsPerFrame(Math.min(clientMaxRowsPerFrame, this.config.getMaxRowsPerFrame()));
    }

    private int adjustForMinumumRowsPerFrame(int rowsPerFrame) {
        return Math.max(this.config.getMinRowsPerFrame(), rowsPerFrame);
    }

    private static String withEscapeClause(String toEscape) {
        return Calcites.escapeStringLiteral(toEscape) + " ESCAPE '\\'";
    }
}

