/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;

public class SqlQueryPlus {
    private final String sql;
    private final Map<String, Object> queryContext;
    private final List<TypedValue> parameters;
    private final AuthenticationResult authResult;

    public SqlQueryPlus(String sql, Map<String, Object> queryContext, List<TypedValue> parameters, AuthenticationResult authResult) {
        this.sql = (String)Preconditions.checkNotNull((Object)sql);
        this.queryContext = queryContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(queryContext));
        this.parameters = parameters == null ? Collections.emptyList() : parameters;
        this.authResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authResult);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sql) {
        return new Builder().sql(sql);
    }

    public static Builder builder(SqlQuery sqlQuery) {
        return new Builder().query(sqlQuery);
    }

    public String sql() {
        return this.sql;
    }

    public Map<String, Object> context() {
        return this.queryContext;
    }

    public List<TypedValue> parameters() {
        return this.parameters;
    }

    public AuthenticationResult authResult() {
        return this.authResult;
    }

    public SqlQueryPlus withContext(Map<String, Object> context) {
        return new SqlQueryPlus(this.sql, context, this.parameters, this.authResult);
    }

    public SqlQueryPlus withParameters(List<TypedValue> parameters) {
        return new SqlQueryPlus(this.sql, this.queryContext, parameters, this.authResult);
    }

    public static class Builder {
        private String sql;
        private Map<String, Object> queryContext;
        private List<TypedValue> parameters;
        private AuthenticationResult authResult;

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder query(SqlQuery sqlQuery) {
            this.sql = sqlQuery.getQuery();
            this.queryContext = sqlQuery.getContext();
            this.parameters = sqlQuery.getParameterList();
            return this;
        }

        public Builder context(Map<String, Object> queryContext) {
            this.queryContext = queryContext;
            return this;
        }

        public Builder parameters(List<TypedValue> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder sqlParameters(List<SqlParameter> parameters) {
            this.parameters = parameters == null ? null : SqlQuery.getParameterList(parameters);
            return this;
        }

        public Builder auth(AuthenticationResult authResult) {
            this.authResult = authResult;
            return this;
        }

        public SqlQueryPlus build() {
            return new SqlQueryPlus(this.sql, this.queryContext, this.parameters, this.authResult);
        }
    }
}

