/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;

public class ReplaceConfigurationOrReturnPreviousCommand
implements GridCommand<BucketConfiguration> {
    private static final long serialVersionUID = 8183759647555953907L;
    private BucketConfiguration newConfiguration;
    private boolean replaced;
    public static SerializationHandle<ReplaceConfigurationOrReturnPreviousCommand> SERIALIZATION_HANDLE = new SerializationHandle<ReplaceConfigurationOrReturnPreviousCommand>(){

        @Override
        public <S> ReplaceConfigurationOrReturnPreviousCommand deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            BucketConfiguration newConfiguration = adapter.readObject(input, BucketConfiguration.class);
            return new ReplaceConfigurationOrReturnPreviousCommand(newConfiguration);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ReplaceConfigurationOrReturnPreviousCommand command) throws IOException {
            adapter.writeObject(output, command.newConfiguration);
        }

        @Override
        public int getTypeId() {
            return 13;
        }

        @Override
        public Class<ReplaceConfigurationOrReturnPreviousCommand> getSerializedType() {
            return ReplaceConfigurationOrReturnPreviousCommand.class;
        }
    };

    public ReplaceConfigurationOrReturnPreviousCommand(BucketConfiguration newConfiguration) {
        this.newConfiguration = newConfiguration;
    }

    @Override
    public BucketConfiguration execute(GridBucketState state, long currentTimeNanos) {
        state.refillAllBandwidth(currentTimeNanos);
        BucketConfiguration previousConfiguration = state.replaceConfigurationOrReturnPrevious(this.newConfiguration);
        if (previousConfiguration != null) {
            return previousConfiguration;
        }
        this.replaced = true;
        return null;
    }

    @Override
    public boolean isBucketStateModified() {
        return this.replaced;
    }

    public BucketConfiguration getNewConfiguration() {
        return this.newConfiguration;
    }
}

