/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;

public class GoogleStorage {
    private final Supplier<Storage> storage;

    public GoogleStorage(Supplier<Storage> storage) {
        this.storage = storage;
    }

    public void insert(String bucket, String path, AbstractInputStreamContent mediaContent) throws IOException {
        Storage.Objects.Insert insertObject = ((Storage)this.storage.get()).objects().insert(bucket, null, mediaContent);
        insertObject.setName(path);
        insertObject.getMediaHttpUploader().setDirectUploadEnabled(false);
        insertObject.execute();
    }

    public InputStream get(String bucket, String path) throws IOException {
        return this.get(bucket, path, 0L);
    }

    public InputStream get(String bucket, String path, long start) throws IOException {
        Storage.Objects.Get get = ((Storage)this.storage.get()).objects().get(bucket, path);
        InputStream inputStream = get.executeMediaAsInputStream();
        inputStream.skip(start);
        return inputStream;
    }

    public void delete(String bucket, String path) throws IOException {
        ((Storage)this.storage.get()).objects().delete(bucket, path).execute();
    }

    public boolean exists(String bucket, String path) {
        try {
            return ((Storage)this.storage.get()).objects().get(bucket, path).executeUsingHead().isSuccessStatusCode();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long size(String bucket, String path) throws IOException {
        return ((StorageObject)((Storage)this.storage.get()).objects().get(bucket, path).execute()).getSize().longValue();
    }

    public String version(String bucket, String path) throws IOException {
        return ((StorageObject)((Storage)this.storage.get()).objects().get(bucket, path).execute()).getEtag();
    }

    public Storage.Objects.List list(String bucket) throws IOException {
        return ((Storage)this.storage.get()).objects().list(bucket);
    }
}

