/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.storage.google.GoogleAccountConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;

public class GoogleDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(GoogleDataSegmentPusher.class);
    private final GoogleStorage storage;
    private final GoogleAccountConfig config;

    @Inject
    public GoogleDataSegmentPusher(GoogleStorage storage, GoogleAccountConfig config) {
        this.storage = storage;
        this.config = config;
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public String getPathForHadoop() {
        return StringUtils.format((String)"gs://%s/%s", (Object[])new Object[]{this.config.getBucket(), this.config.getPrefix()});
    }

    public List<String> getAllowedPropertyPrefixesForHadoop() {
        return ImmutableList.of((Object)"druid.google");
    }

    public void insert(File file, String contentType, String path) throws IOException {
        log.debug("Inserting [%s] to [%s]", new Object[]{file, path});
        try {
            RetryUtils.retry(() -> {
                this.storage.insert(this.config.getBucket(), path, (AbstractInputStreamContent)new FileContent(contentType, file));
                return null;
            }, GoogleUtils::isRetryable, (int)1, (int)5);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to upload [%s] to [%s]", new Object[]{file, path});
        }
    }

    public DataSegment push(File indexFilesDir, DataSegment segment, boolean useUniquePath) throws IOException {
        log.debug("Uploading [%s] to Google.", new Object[]{indexFilesDir});
        String storageDir = this.getStorageDir(segment, useUniquePath);
        return this.pushToPath(indexFilesDir, segment, storageDir);
    }

    public DataSegment pushToPath(File indexFilesDir, DataSegment segment, String storageDirSuffix) throws IOException {
        DataSegment dataSegment;
        block5: {
            int version = SegmentUtils.getVersionFromDir((File)indexFilesDir);
            File indexFile = null;
            try {
                indexFile = File.createTempFile("index", ".zip");
                long indexSize = CompressionUtils.zip((File)indexFilesDir, (File)indexFile);
                String indexPath = this.buildPath(storageDirSuffix + "/index.zip");
                DataSegment outSegment = segment.withSize(indexSize).withLoadSpec(this.makeLoadSpec(this.config.getBucket(), indexPath)).withBinaryVersion(version);
                this.insert(indexFile, "application/zip", indexPath);
                dataSegment = outSegment;
                if (indexFile == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (indexFile != null) {
                        log.debug("Deleting file [%s]", new Object[]{indexFile});
                        indexFile.delete();
                    }
                    throw throwable;
                }
            }
            log.debug("Deleting file [%s]", new Object[]{indexFile});
            indexFile.delete();
        }
        return dataSegment;
    }

    @VisibleForTesting
    String buildPath(String path) {
        if (!Strings.isNullOrEmpty((String)this.config.getPrefix())) {
            return this.config.getPrefix() + "/" + path;
        }
        return path;
    }

    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return this.makeLoadSpec(this.config.getBucket(), finalIndexZipFilePath.getPath().substring(1));
    }

    private Map<String, Object> makeLoadSpec(String bucket, String path) {
        return ImmutableMap.of((Object)"type", (Object)"google", (Object)"bucket", (Object)bucket, (Object)"path", (Object)path);
    }
}

