/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.druid.storage.google.GoogleStorage;

public class GoogleByteSource
extends ByteSource {
    private final GoogleStorage storage;
    private final String bucket;
    private final String path;

    public GoogleByteSource(GoogleStorage storage, String bucket, String path) {
        this.storage = storage;
        this.bucket = bucket;
        this.path = path;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPath() {
        return this.path;
    }

    public InputStream openStream() throws IOException {
        return this.storage.get(this.bucket, this.path);
    }

    public InputStream openStream(long start) throws IOException {
        return this.storage.get(this.bucket, this.path, start);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GoogleByteSource that = (GoogleByteSource)((Object)o);
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.path);
    }
}

