/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.druid.indexing.kafka.KafkaRecordSupplier;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorSpec;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSamplerSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;

public class KafkaSamplerSpec
extends SeekableStreamSamplerSpec {
    private final ObjectMapper objectMapper;

    @JsonCreator
    public KafkaSamplerSpec(@JsonProperty(value="spec") KafkaSupervisorSpec ingestionSpec, @JsonProperty(value="samplerConfig") @Nullable SamplerConfig samplerConfig, @JacksonInject InputSourceSampler inputSourceSampler, @JacksonInject ObjectMapper objectMapper) {
        super((SeekableStreamSupervisorSpec)ingestionSpec, samplerConfig, inputSourceSampler);
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KafkaRecordSupplier createRecordSupplier() {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            HashMap<String, Object> props = new HashMap<String, Object>(((KafkaSupervisorIOConfig)this.ioConfig).getConsumerProperties());
            props.put("enable.auto.commit", "false");
            props.put("auto.offset.reset", "none");
            props.put("request.timeout.ms", Integer.toString(this.samplerConfig.getTimeoutMs()));
            KafkaRecordSupplier kafkaRecordSupplier = new KafkaRecordSupplier(props, this.objectMapper, ((KafkaSupervisorIOConfig)this.ioConfig).getConfigOverrides());
            return kafkaRecordSupplier;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }
}

