/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafkainput;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafkainput.KafkaHeaderFormat;
import org.apache.druid.data.input.kafkainput.KafkaInputReader;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.DateTimes;

public class KafkaInputFormat
implements InputFormat {
    private static final String DEFAULT_HEADER_COLUMN_PREFIX = "kafka.header.";
    private static final String DEFAULT_TIMESTAMP_COLUMN_NAME = "kafka.timestamp";
    private static final String DEFAULT_KEY_COLUMN_NAME = "kafka.key";
    public static final String DEFAULT_AUTO_TIMESTAMP_STRING = "__kif_auto_timestamp";
    private final TimestampSpec dummyTimestampSpec = new TimestampSpec("__kif_auto_timestamp", "auto", DateTimes.EPOCH);
    private final KafkaHeaderFormat headerFormat;
    private final InputFormat valueFormat;
    private final InputFormat keyFormat;
    private final String headerColumnPrefix;
    private final String keyColumnName;
    private final String timestampColumnName;

    public KafkaInputFormat(@JsonProperty(value="headerFormat") @Nullable KafkaHeaderFormat headerFormat, @JsonProperty(value="keyFormat") @Nullable InputFormat keyFormat, @JsonProperty(value="valueFormat") InputFormat valueFormat, @JsonProperty(value="headerColumnPrefix") @Nullable String headerColumnPrefix, @JsonProperty(value="keyColumnName") @Nullable String keyColumnName, @JsonProperty(value="timestampColumnName") @Nullable String timestampColumnName) {
        this.headerFormat = headerFormat;
        this.keyFormat = keyFormat;
        this.valueFormat = (InputFormat)Preconditions.checkNotNull((Object)valueFormat, (Object)"valueFormat must not be null");
        this.headerColumnPrefix = headerColumnPrefix != null ? headerColumnPrefix : DEFAULT_HEADER_COLUMN_PREFIX;
        this.keyColumnName = keyColumnName != null ? keyColumnName : DEFAULT_KEY_COLUMN_NAME;
        this.timestampColumnName = timestampColumnName != null ? timestampColumnName : DEFAULT_TIMESTAMP_COLUMN_NAME;
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        SettableByteEntity settableByteEntitySource = (SettableByteEntity)source;
        InputRowSchema newInputRowSchema = new InputRowSchema(this.dummyTimestampSpec, inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter());
        return new KafkaInputReader(inputRowSchema, (SettableByteEntity<KafkaRecordEntity>)settableByteEntitySource, this.headerFormat == null ? null : record -> this.headerFormat.createReader(record.getRecord().headers(), this.headerColumnPrefix), this.keyFormat == null ? null : record -> record.getRecord().key() == null ? null : this.keyFormat.createReader(newInputRowSchema, (InputEntity)new ByteEntity((byte[])record.getRecord().key()), temporaryDirectory), this.valueFormat.createReader(newInputRowSchema, source, temporaryDirectory), this.keyColumnName, this.timestampColumnName);
    }

    @Nullable
    @JsonProperty
    public KafkaHeaderFormat getHeaderFormat() {
        return this.headerFormat;
    }

    @JsonProperty
    public InputFormat getValueFormat() {
        return this.valueFormat;
    }

    @Nullable
    @JsonProperty
    public InputFormat getKeyFormat() {
        return this.keyFormat;
    }

    @Nullable
    @JsonProperty
    public String getHeaderColumnPrefix() {
        return this.headerColumnPrefix;
    }

    @Nullable
    @JsonProperty
    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    @Nullable
    @JsonProperty
    public String getTimestampColumnName() {
        return this.timestampColumnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaInputFormat that = (KafkaInputFormat)o;
        return Objects.equals(this.headerFormat, that.headerFormat) && Objects.equals(this.valueFormat, that.valueFormat) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.headerColumnPrefix, that.headerColumnPrefix) && Objects.equals(this.keyColumnName, that.keyColumnName) && Objects.equals(this.timestampColumnName, that.timestampColumnName);
    }

    public int hashCode() {
        return Objects.hash(this.headerFormat, this.valueFormat, this.keyFormat, this.headerColumnPrefix, this.keyColumnName, this.timestampColumnName);
    }
}

