/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class RangerPluginContext {
    private static final Log LOG = LogFactory.getLog(RangerBasePlugin.class);
    private String clusterName;
    private String clusterType;

    public RangerPluginContext(String serviceType) {
        this.clusterName = this.findClusterName(serviceType);
        this.clusterType = this.findClusterType(serviceType);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    private String findClusterName(String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPluginContext.findClusterName , serviceType = " + serviceType));
        }
        String propertyPrefix = "ranger.plugin." + serviceType;
        String clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty(clusterName)) {
            clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".ambari.cluster.name", "");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPluginContext.findClusterName ");
        }
        return clusterName;
    }

    private String findClusterType(String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPluginContext.findClusterType , serviceType = " + serviceType));
        }
        String propertyPrefix = "ranger.plugin." + serviceType;
        String clusterType = RangerConfiguration.getInstance().get(propertyPrefix + ".access.cluster.type", "");
        if (StringUtil.isEmpty(clusterType)) {
            clusterType = RangerConfiguration.getInstance().get(propertyPrefix + ".ambari.cluster.type", "");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPluginContext.findClusterType ");
        }
        return clusterType;
    }
}

