/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerPolicyDelta
implements Serializable {
    public static final int CHANGE_TYPE_POLICY_CREATE = 0;
    public static final int CHANGE_TYPE_POLICY_UPDATE = 1;
    public static final int CHANGE_TYPE_POLICY_DELETE = 2;
    public static final int CHANGE_TYPE_SERVICE_CHANGE = 3;
    public static final int CHANGE_TYPE_SERVICE_DEF_CHANGE = 4;
    public static final int CHANGE_TYPE_RANGER_ADMIN_START = 5;
    public static final int CHANGE_TYPE_LOG_ERROR = 6;
    private static String[] changeTypeNames = new String[]{"POLICY_CREATE", "POLICY_UPDATE", "POLICY_DELETE", "SERVICE_CHANGE", "SERVICE_DEF_CHANGE", "RANGER_ADMIN_START", "LOG_ERROR"};
    private Long id;
    private Integer changeType;
    private RangerPolicy policy;

    public RangerPolicyDelta() {
        this(null, null, null);
    }

    public RangerPolicyDelta(Long id, Integer changeType, RangerPolicy policy) {
        this.setId(id);
        this.setChangeType(changeType);
        this.setPolicy(policy);
    }

    public Long getId() {
        return this.id;
    }

    public Integer getChangeType() {
        return this.changeType;
    }

    @JsonIgnore
    public Long getPolicyVersion() {
        return this.policy != null ? this.policy.getVersion() : null;
    }

    @JsonIgnore
    public String getServiceType() {
        return this.policy != null ? this.policy.getServiceType() : null;
    }

    @JsonIgnore
    public Integer getPolicyType() {
        return this.policy != null ? this.policy.getPolicyType() : null;
    }

    @JsonIgnore
    public Long getPolicyId() {
        return this.policy != null ? this.policy.getId() : null;
    }

    @JsonIgnore
    public String getZoneName() {
        return this.policy != null ? this.policy.getZoneName() : null;
    }

    public RangerPolicy getPolicy() {
        return this.policy;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public void setPolicy(RangerPolicy policy) {
        this.policy = policy;
    }

    public String toString() {
        return "id:" + this.id + ", changeType:" + changeTypeNames[this.changeType] + ", policyVersion:" + this.getPolicyVersion() + ", serviceType:" + this.getServiceType() + ", policyType:" + this.getPolicyType() + ", policyId:[" + this.getPolicyId() + "], policy:[" + this.policy + "]";
    }
}

