/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.druid.java.util.common.IAE;

public final class ConnectionUriUtils {
    private static final String MARIADB_EXTRAS = "nonMappedOptions";
    public static final String MYSQL_PREFIX = "jdbc:mysql:";
    public static final String POSTGRES_PREFIX = "jdbc:postgresql:";
    public static final String MARIADB_PREFIX = "jdbc:mariadb:";
    public static final String POSTGRES_DRIVER = "org.postgresql.Driver";
    public static final String MYSQL_NON_REGISTERING_DRIVER = "com.mysql.jdbc.NonRegisteringDriver";

    public static void throwIfPropertiesAreNotAllowed(Set<String> actualProperties, Set<String> systemPropertyPrefixes, Set<String> allowedProperties) {
        for (String property : actualProperties) {
            if (!systemPropertyPrefixes.stream().noneMatch(property::startsWith)) continue;
            Preconditions.checkArgument((boolean)allowedProperties.contains(property), (String)"The property [%s] is not in the allowed list %s", (Object[])new Object[]{property, allowedProperties});
        }
    }

    public static Set<String> tryParseJdbcUriParameters(String connectionUri, boolean allowUnknown) {
        if (connectionUri.startsWith(MYSQL_PREFIX)) {
            try {
                return ConnectionUriUtils.tryParseMySqlConnectionUri(connectionUri);
            }
            catch (ClassNotFoundException notFoundMysql) {
                try {
                    return ConnectionUriUtils.tryParseMariaDb2xConnectionUri(connectionUri);
                }
                catch (ClassNotFoundException notFoundMaria2x) {
                    throw new RuntimeException("Failed to find MySQL driver class. Please check the MySQL connector version 5.1.49 is in the classpath", notFoundMysql);
                }
                catch (IllegalArgumentException iaeMaria2x) {
                    throw iaeMaria2x;
                }
                catch (Throwable otherMaria2x) {
                    throw new RuntimeException(otherMaria2x);
                }
            }
            catch (IllegalArgumentException iaeMySql) {
                throw iaeMySql;
            }
            catch (Throwable otherMysql) {
                throw new RuntimeException(otherMysql);
            }
        }
        if (connectionUri.startsWith(MARIADB_PREFIX)) {
            try {
                return ConnectionUriUtils.tryParseMariaDb2xConnectionUri(connectionUri);
            }
            catch (ClassNotFoundException notFoundMaria2x) {
                try {
                    return ConnectionUriUtils.tryParseMariaDb3xConnectionUri(connectionUri);
                }
                catch (ClassNotFoundException notFoundMaria3x) {
                    throw new RuntimeException("Failed to find MariaDB driver class. Please check the MariaDB connector version 2.7.3 is in the classpath", notFoundMaria2x);
                }
                catch (IllegalArgumentException iaeMaria3x) {
                    throw iaeMaria3x;
                }
                catch (Throwable otherMaria3x) {
                    throw new RuntimeException(otherMaria3x);
                }
            }
            catch (IllegalArgumentException iaeMaria2x) {
                throw iaeMaria2x;
            }
            catch (Throwable otherMaria2x) {
                throw new RuntimeException(otherMaria2x);
            }
        }
        if (connectionUri.startsWith(POSTGRES_PREFIX)) {
            try {
                return ConnectionUriUtils.tryParsePostgresConnectionUri(connectionUri);
            }
            catch (IllegalArgumentException iaePostgres) {
                throw iaePostgres;
            }
            catch (Throwable otherPostgres) {
                throw new RuntimeException(otherPostgres);
            }
        }
        if (!allowUnknown) {
            throw new IAE("Unknown JDBC connection scheme: %s", connectionUri.split(":")[1]);
        }
        return Collections.emptySet();
    }

    public static Set<String> tryParsePostgresConnectionUri(String connectionUri) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> driverClass = Class.forName(POSTGRES_DRIVER);
        Method parseUrl = driverClass.getMethod("parseURL", String.class, Properties.class);
        Properties properties = (Properties)parseUrl.invoke(null, connectionUri, null);
        if (properties == null) {
            throw new IAE("Invalid URL format for PostgreSQL: [%s]", connectionUri);
        }
        HashSet keys = Sets.newHashSetWithExpectedSize((int)properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> keys.add((String)k)));
        return keys;
    }

    public static Set<String> tryParseMySqlConnectionUri(String connectionUri) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> driverClass = Class.forName(MYSQL_NON_REGISTERING_DRIVER);
        Method parseUrl = driverClass.getMethod("parseURL", String.class, Properties.class);
        Properties properties = (Properties)parseUrl.invoke(driverClass.getConstructor(new Class[0]).newInstance(new Object[0]), connectionUri, null);
        if (properties == null) {
            throw new IAE("Invalid URL format for MySQL: [%s]", connectionUri);
        }
        HashSet keys = Sets.newHashSetWithExpectedSize((int)properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> keys.add((String)k)));
        return keys;
    }

    public static Set<String> tryParseMariaDb2xConnectionUri(String connectionUri) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        Class<?> urlParserClass = Class.forName("org.mariadb.jdbc.UrlParser");
        Class<?> optionsClass = Class.forName("org.mariadb.jdbc.util.Options");
        Method parseUrl = urlParserClass.getMethod("parse", String.class);
        Method getOptions = urlParserClass.getMethod("getOptions", new Class[0]);
        Object urlParser = parseUrl.invoke(null, connectionUri);
        if (urlParser == null) {
            throw new IAE("Invalid URL format for MariaDB: [%s]", connectionUri);
        }
        Object options = getOptions.invoke(urlParser, new Object[0]);
        Field nonMappedOptionsField = optionsClass.getField(MARIADB_EXTRAS);
        Properties properties = (Properties)nonMappedOptionsField.get(options);
        Field[] fields = optionsClass.getDeclaredFields();
        HashSet keys = Sets.newHashSetWithExpectedSize((int)(properties.size() + fields.length));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> keys.add((String)k)));
        Object defaultOptions = optionsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : fields) {
            if (field.getName().equals(MARIADB_EXTRAS)) continue;
            try {
                if (Objects.equal((Object)field.get(options), (Object)field.get(defaultOptions))) continue;
                keys.add(field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return keys;
    }

    public static Set<String> tryParseMariaDb3xConnectionUri(String connectionUri) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> configurationClass = Class.forName("org.mariadb.jdbc.Configuration");
        Class<?> configurationBuilderClass = Class.forName("org.mariadb.jdbc.Configuration$Builder");
        Method parseUrl = configurationClass.getMethod("parse", String.class);
        Method buildMethod = configurationBuilderClass.getMethod("build", new Class[0]);
        Object configuration = parseUrl.invoke(null, connectionUri);
        if (configuration == null) {
            throw new IAE("Invalid URL format for MariaDB: [%s]", connectionUri);
        }
        Method nonMappedOptionsGetter = configurationClass.getMethod(MARIADB_EXTRAS, new Class[0]);
        Properties properties = (Properties)nonMappedOptionsGetter.invoke(configuration, new Object[0]);
        Field[] fields = configurationClass.getDeclaredFields();
        HashSet keys = Sets.newHashSetWithExpectedSize((int)(properties.size() + fields.length));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> keys.add((String)k)));
        Object defaultConfiguration = buildMethod.invoke(configurationBuilderClass.getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
        for (Field field : fields) {
            if (field.getName().equals(MARIADB_EXTRAS)) continue;
            try {
                Method fieldGetter = configurationClass.getMethod(field.getName(), new Class[0]);
                if (Objects.equal((Object)fieldGetter.invoke(configuration, new Object[0]), (Object)fieldGetter.invoke(defaultConfiguration, new Object[0]))) continue;
                keys.add(field.getName());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return keys;
    }

    private ConnectionUriUtils() {
    }
}

