/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectMap;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectSortedMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparators;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.AtomicUpdateGroup;
import org.apache.druid.timeline.partition.PartitionChunk;

class OvershadowableManager<T extends Overshadowable<T>> {
    private final Map<Integer, PartitionChunk<T>> knownPartitionChunks = new HashMap<Integer, PartitionChunk<T>>();
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> standbyGroups = new TreeMap();
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> visibleGroupPerRange = new TreeMap();
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> overshadowedGroups = new TreeMap();

    OvershadowableManager() {
    }

    public static <T extends Overshadowable<T>> OvershadowableManager<T> copyVisible(OvershadowableManager<T> original) {
        OvershadowableManager<T> copy = new OvershadowableManager<T>();
        original.visibleGroupPerRange.forEach((partitionRange, versionToGroups) -> {
            AtomicUpdateGroup group = (AtomicUpdateGroup)versionToGroups.values().iterator().next();
            group.getChunks().forEach(chunk -> copy.knownPartitionChunks.put(chunk.getChunkNumber(), (PartitionChunk)chunk));
            copy.visibleGroupPerRange.put((RootPartitionRange)partitionRange, (Short2ObjectSortedMap)new SingleEntryShort2ObjectSortedMap(group.getMinorVersion(), AtomicUpdateGroup.copy(group)));
        });
        return copy;
    }

    public static <T extends Overshadowable<T>> OvershadowableManager<T> deepCopy(OvershadowableManager<T> original) {
        OvershadowableManager<T> copy = OvershadowableManager.copyVisible(original);
        original.overshadowedGroups.forEach((partitionRange, versionToGroups) -> {
            AtomicUpdateGroup group = (AtomicUpdateGroup)versionToGroups.values().iterator().next();
            group.getChunks().forEach(chunk -> copy.knownPartitionChunks.put(chunk.getChunkNumber(), (PartitionChunk)chunk));
            copy.overshadowedGroups.put((RootPartitionRange)partitionRange, (Short2ObjectSortedMap)new SingleEntryShort2ObjectSortedMap(group.getMinorVersion(), AtomicUpdateGroup.copy(group)));
        });
        original.standbyGroups.forEach((partitionRange, versionToGroups) -> {
            AtomicUpdateGroup group = (AtomicUpdateGroup)versionToGroups.values().iterator().next();
            group.getChunks().forEach(chunk -> copy.knownPartitionChunks.put(chunk.getChunkNumber(), (PartitionChunk)chunk));
            copy.standbyGroups.put((RootPartitionRange)partitionRange, (Short2ObjectSortedMap)new SingleEntryShort2ObjectSortedMap(group.getMinorVersion(), AtomicUpdateGroup.copy(group)));
        });
        return copy;
    }

    private TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> getStateMap(State state) {
        switch (state) {
            case STANDBY: {
                return this.standbyGroups;
            }
            case VISIBLE: {
                return this.visibleGroupPerRange;
            }
            case OVERSHADOWED: {
                return this.overshadowedGroups;
            }
        }
        throw new ISE("Unknown state[%s]", new Object[]{state});
    }

    private Short2ObjectSortedMap<AtomicUpdateGroup<T>> createMinorVersionToAugMap(State state) {
        switch (state) {
            case STANDBY: 
            case OVERSHADOWED: {
                return new Short2ObjectRBTreeMap();
            }
            case VISIBLE: {
                return new SingleEntryShort2ObjectSortedMap();
            }
        }
        throw new ISE("Unknown state[%s]", new Object[]{state});
    }

    private void transitAtomicUpdateGroupState(AtomicUpdateGroup<T> atomicUpdateGroup, State from, State to) {
        Preconditions.checkNotNull(atomicUpdateGroup, (Object)"atomicUpdateGroup");
        Preconditions.checkArgument((!atomicUpdateGroup.isEmpty() ? 1 : 0) != 0, (Object)"empty atomicUpdateGroup");
        this.removeFrom(atomicUpdateGroup, from);
        this.addAtomicUpdateGroupWithState(atomicUpdateGroup, to, false);
    }

    private void replaceVisibleWith(Collection<AtomicUpdateGroup<T>> oldVisibleGroups, State newStateOfOldVisibleGroup, Collection<AtomicUpdateGroup<T>> newVisibleGroups, State oldStateOfNewVisibleGroups) {
        oldVisibleGroups.forEach(group -> {
            if (!group.isEmpty()) {
                this.removeFrom((AtomicUpdateGroup<T>)group, State.VISIBLE);
            }
        });
        newVisibleGroups.forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, oldStateOfNewVisibleGroups, State.VISIBLE));
        oldVisibleGroups.forEach(group -> {
            if (!group.isEmpty()) {
                this.addAtomicUpdateGroupWithState((AtomicUpdateGroup<T>)group, newStateOfOldVisibleGroup, false);
            }
        });
    }

    @Nullable
    private AtomicUpdateGroup<T> findAtomicUpdateGroupWith(PartitionChunk<T> chunk, State state) {
        AtomicUpdateGroup atomicUpdateGroup;
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(RootPartitionRange.of(chunk));
        if (versionToGroup != null && (atomicUpdateGroup = (AtomicUpdateGroup)versionToGroup.get(((Overshadowable)chunk.getObject()).getMinorVersion())) != null) {
            return atomicUpdateGroup;
        }
        return null;
    }

    @Nullable
    private AtomicUpdateGroup<T> tryRemoveChunkFromGroupWithState(PartitionChunk<T> chunk, State state) {
        AtomicUpdateGroup atomicUpdateGroup;
        RootPartitionRange rangeKey = RootPartitionRange.of(chunk);
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(rangeKey);
        if (versionToGroup != null && (atomicUpdateGroup = (AtomicUpdateGroup)versionToGroup.get(((Overshadowable)chunk.getObject()).getMinorVersion())) != null) {
            atomicUpdateGroup.remove(chunk);
            if (atomicUpdateGroup.isEmpty()) {
                versionToGroup.remove(((Overshadowable)chunk.getObject()).getMinorVersion());
                if (versionToGroup.isEmpty()) {
                    this.getStateMap(state).remove(rangeKey);
                }
            }
            this.determineVisibleGroupAfterRemove(atomicUpdateGroup, RootPartitionRange.of(chunk), ((Overshadowable)chunk.getObject()).getMinorVersion(), state);
            return atomicUpdateGroup;
        }
        return null;
    }

    private List<AtomicUpdateGroup<T>> findOvershadowedBy(AtomicUpdateGroup<T> aug, State fromState) {
        RootPartitionRange rangeKeyOfGivenAug = RootPartitionRange.of(aug);
        return this.findOvershadowedBy(rangeKeyOfGivenAug, aug.getMinorVersion(), fromState);
    }

    @VisibleForTesting
    List<AtomicUpdateGroup<T>> findOvershadowedBy(RootPartitionRange rangeOfAug, short minorVersion, State fromState) {
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current;
        TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap = this.getStateMap(fromState);
        ArrayList<AtomicUpdateGroup<T>> found = new ArrayList<AtomicUpdateGroup<T>>();
        Iterator<Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>> iterator = this.entryIteratorGreaterThan(rangeOfAug.startPartitionId, stateMap);
        while (iterator.hasNext() && rangeOfAug.contains((current = iterator.next()).getKey())) {
            Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = current.getValue();
            if (versionToGroup.firstShortKey() >= minorVersion) continue;
            found.addAll((Collection<AtomicUpdateGroup<T>>)versionToGroup.headMap(minorVersion).values());
        }
        return found;
    }

    private List<AtomicUpdateGroup<T>> findOvershadows(AtomicUpdateGroup<T> aug, State fromState) {
        return this.findOvershadows(RootPartitionRange.of(aug), aug.getMinorVersion(), fromState);
    }

    @VisibleForTesting
    List<AtomicUpdateGroup<T>> findOvershadows(RootPartitionRange rangeOfAug, short minorVersion, State fromState) {
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current;
        TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap = this.getStateMap(fromState);
        Iterator<Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>> iterator = this.entryIteratorSmallerThan(rangeOfAug.endPartitionId, stateMap);
        ArrayList<AtomicUpdateGroup<T>> found = new ArrayList<AtomicUpdateGroup<T>>();
        while (iterator.hasNext() && (current = iterator.next()).getKey().overlaps(rangeOfAug)) {
            Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup;
            if (!current.getKey().contains(rangeOfAug) || (versionToGroup = current.getValue()).lastShortKey() <= minorVersion) continue;
            found.addAll((Collection<AtomicUpdateGroup<T>>)versionToGroup.tailMap(minorVersion).values());
        }
        return found;
    }

    boolean isOvershadowedByVisibleGroup(RootPartitionRange partitionRange, short minorVersion) {
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current;
        Iterator<Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>> iterator = this.entryIteratorSmallerThan(partitionRange.endPartitionId, this.visibleGroupPerRange);
        while (iterator.hasNext() && (current = iterator.next()).getKey().overlaps(partitionRange)) {
            Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup;
            if (!current.getKey().contains(partitionRange) || (versionToGroup = current.getValue()).lastShortKey() <= minorVersion) continue;
            return true;
        }
        return false;
    }

    private Iterator<Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>> entryIteratorSmallerThan(short partitionId, TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap) {
        RootPartitionRange lowFench = new RootPartitionRange(0, 0);
        RootPartitionRange highFence = new RootPartitionRange(partitionId, partitionId);
        return stateMap.subMap(lowFench, false, highFence, false).descendingMap().entrySet().iterator();
    }

    private Iterator<Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>> entryIteratorGreaterThan(short partitionId, TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap) {
        RootPartitionRange lowFench = new RootPartitionRange(partitionId, partitionId);
        RootPartitionRange highFence = new RootPartitionRange(Short.MAX_VALUE, Short.MAX_VALUE);
        return stateMap.subMap(lowFench, false, highFence, false).entrySet().iterator();
    }

    private void determineVisibleGroupAfterAdd(AtomicUpdateGroup<T> aug, State stateOfAug) {
        if (stateOfAug == State.STANDBY) {
            this.moveNewStandbyToVisibleIfNecessary(aug, stateOfAug);
        } else if (stateOfAug == State.OVERSHADOWED) {
            this.checkVisibleIsFullyAvailableAndTryToMoveOvershadowedToVisible(aug, stateOfAug);
        }
    }

    private void moveNewStandbyToVisibleIfNecessary(AtomicUpdateGroup<T> standbyGroup, State stateOfGroup) {
        assert (stateOfGroup == State.STANDBY);
        if (standbyGroup.isFull()) {
            this.replaceVisibleWith(this.findOvershadowedBy(standbyGroup, State.VISIBLE), State.OVERSHADOWED, Collections.singletonList(standbyGroup), State.STANDBY);
            this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
        } else if (!standbyGroup.isEmpty()) {
            List<AtomicUpdateGroup<T>> overshadowedVisibles = this.findOvershadowedBy(standbyGroup, State.VISIBLE);
            if (overshadowedVisibles.isEmpty()) {
                this.transitAtomicUpdateGroupState(standbyGroup, State.STANDBY, State.VISIBLE);
                this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
            } else {
                boolean fullyCoverAugRange = this.doGroupsFullyCoverPartitionRange(overshadowedVisibles, standbyGroup.getStartRootPartitionId(), standbyGroup.getEndRootPartitionId());
                if (!fullyCoverAugRange) {
                    this.replaceVisibleWith(overshadowedVisibles, State.OVERSHADOWED, Collections.singletonList(standbyGroup), State.STANDBY);
                    this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
                }
            }
        }
    }

    private void checkVisibleIsFullyAvailableAndTryToMoveOvershadowedToVisible(AtomicUpdateGroup<T> group, State stateOfGroup) {
        assert (stateOfGroup == State.OVERSHADOWED);
        if (group.isFull()) {
            boolean isOvershadowedGroupsFull;
            ImmutableList latestFullGroups;
            boolean isOvershadowingGroupsFull;
            List<AtomicUpdateGroup<T>> groupsOvershadowingAug;
            List<AtomicUpdateGroup<T>> overshadowingVisibles = this.findOvershadows(group, State.VISIBLE);
            if (overshadowingVisibles.isEmpty()) {
                List<AtomicUpdateGroup<T>> overshadowingStandbys = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadows(group, State.STANDBY));
                if (overshadowingStandbys.isEmpty()) {
                    throw new ISE("Unexpected state: atomicUpdateGroup[%s] is overshadowed, but nothing overshadows it", group);
                }
                groupsOvershadowingAug = overshadowingStandbys;
                isOvershadowingGroupsFull = false;
            } else {
                groupsOvershadowingAug = overshadowingVisibles;
                isOvershadowingGroupsFull = this.doGroupsFullyCoverPartitionRange(groupsOvershadowingAug, groupsOvershadowingAug.get(0).getStartRootPartitionId(), groupsOvershadowingAug.get(groupsOvershadowingAug.size() - 1).getEndRootPartitionId());
            }
            if (!isOvershadowingGroupsFull && !(latestFullGroups = FluentIterable.from(groupsOvershadowingAug).transformAndConcat(eachFullgroup -> this.findLatestFullyAvailableOvershadowedAtomicUpdateGroups(RootPartitionRange.of(eachFullgroup), eachFullgroup.getMinorVersion())).toList()).isEmpty() && (isOvershadowedGroupsFull = this.doGroupsFullyCoverPartitionRange((List<AtomicUpdateGroup<T>>)latestFullGroups, groupsOvershadowingAug.get(0).getStartRootPartitionId(), groupsOvershadowingAug.get(groupsOvershadowingAug.size() - 1).getEndRootPartitionId()))) {
                this.replaceVisibleWith((Collection<AtomicUpdateGroup<T>>)overshadowingVisibles, State.STANDBY, (Collection<AtomicUpdateGroup<T>>)latestFullGroups, State.OVERSHADOWED);
            }
        }
    }

    private boolean doGroupsFullyCoverPartitionRange(List<AtomicUpdateGroup<T>> groups, int startRootPartitionId, int endRootPartitionId) {
        int startRootPartitionIdOfOvershadowed = groups.get(0).getStartRootPartitionId();
        int endRootPartitionIdOfOvershadowed = groups.get(groups.size() - 1).getEndRootPartitionId();
        if (startRootPartitionId != startRootPartitionIdOfOvershadowed || endRootPartitionId != endRootPartitionIdOfOvershadowed) {
            return false;
        }
        int prevEndPartitionId = groups.get(0).getStartRootPartitionId();
        for (AtomicUpdateGroup<T> group : groups) {
            if (!group.isFull() || prevEndPartitionId != group.getStartRootPartitionId()) {
                return false;
            }
            prevEndPartitionId = group.getEndRootPartitionId();
        }
        return true;
    }

    private void addAtomicUpdateGroupWithState(AtomicUpdateGroup<T> aug, State state, boolean determineVisible) {
        AtomicUpdateGroup existing = (AtomicUpdateGroup)this.getStateMap(state).computeIfAbsent(RootPartitionRange.of(aug), k -> this.createMinorVersionToAugMap(state)).put(aug.getMinorVersion(), aug);
        if (existing != null) {
            throw new ISE("AtomicUpdateGroup[%s] is already in state[%s]", new Object[]{existing, state});
        }
        if (determineVisible) {
            this.determineVisibleGroupAfterAdd(aug, state);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean addChunk(PartitionChunk<T> chunk) {
        PartitionChunk<T> existingChunk = this.knownPartitionChunks.put(chunk.getChunkNumber(), chunk);
        if (existingChunk != null) {
            if (existingChunk.equals(chunk)) return false;
            throw new ISE("existingChunk[%s] is different from newChunk[%s] for partitionId[%d]", existingChunk, chunk, chunk.getChunkNumber());
        }
        AtomicUpdateGroup<T> atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.OVERSHADOWED);
        if (atomicUpdateGroup != null) {
            atomicUpdateGroup.add(chunk);
            this.determineVisibleGroupAfterAdd(atomicUpdateGroup, State.OVERSHADOWED);
            return true;
        } else {
            atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.STANDBY);
            if (atomicUpdateGroup != null) {
                atomicUpdateGroup.add(chunk);
                this.determineVisibleGroupAfterAdd(atomicUpdateGroup, State.STANDBY);
                return true;
            } else {
                atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.VISIBLE);
                if (atomicUpdateGroup != null) {
                    if (atomicUpdateGroup.findChunk(chunk.getChunkNumber()) != null) throw new ISE("Unexpected state: chunk[%s] is in the atomicUpdateGroup[%s] but not in knownPartitionChunks[%s]", chunk, atomicUpdateGroup, this.knownPartitionChunks);
                    if (atomicUpdateGroup.isFull()) throw new ISE("Can't add chunk[%s] to a full atomicUpdateGroup[%s]", chunk, atomicUpdateGroup);
                    atomicUpdateGroup.add(chunk);
                    return true;
                } else {
                    AtomicUpdateGroup<T> newAtomicUpdateGroup = new AtomicUpdateGroup<T>(chunk);
                    boolean overshadowed = this.isOvershadowedByVisibleGroup(RootPartitionRange.of(newAtomicUpdateGroup), newAtomicUpdateGroup.getMinorVersion());
                    if (overshadowed) {
                        this.addAtomicUpdateGroupWithState(newAtomicUpdateGroup, State.OVERSHADOWED, true);
                        return true;
                    } else {
                        this.addAtomicUpdateGroupWithState(newAtomicUpdateGroup, State.STANDBY, true);
                    }
                }
            }
        }
        return true;
    }

    private void determineVisibleGroupAfterRemove(AtomicUpdateGroup<T> augOfRemovedChunk, RootPartitionRange rangeOfAug, short minorVersion, State stateOfRemovedAug) {
        if (stateOfRemovedAug == State.VISIBLE) {
            List<AtomicUpdateGroup<T>> latestFullAugs = this.findLatestFullyAvailableOvershadowedAtomicUpdateGroups(rangeOfAug, minorVersion);
            if (!latestFullAugs.isEmpty()) {
                ImmutableSet overshadowsLatestFullAugsInVisible = FluentIterable.from(latestFullAugs).transformAndConcat(group -> this.findOvershadows((AtomicUpdateGroup<T>)group, State.VISIBLE)).toSet();
                this.replaceVisibleWith((Collection<AtomicUpdateGroup<T>>)overshadowsLatestFullAugsInVisible, State.STANDBY, (Collection<AtomicUpdateGroup<T>>)latestFullAugs, State.OVERSHADOWED);
                FluentIterable.from(latestFullAugs).transformAndConcat(group -> this.findOvershadows((AtomicUpdateGroup<T>)group, State.OVERSHADOWED)).forEach(group -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)group, State.OVERSHADOWED, State.STANDBY));
            } else {
                List<AtomicUpdateGroup<AtomicUpdateGroup>> latestOvershadowed;
                List<AtomicUpdateGroup<T>> latestStandby = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadows(rangeOfAug, minorVersion, State.STANDBY));
                if (!latestStandby.isEmpty()) {
                    ImmutableList overshadowedByLatestStandby = FluentIterable.from(latestStandby).transformAndConcat(group -> this.findOvershadowedBy((AtomicUpdateGroup<T>)group, State.VISIBLE)).toList();
                    this.replaceVisibleWith((Collection<AtomicUpdateGroup<T>>)overshadowedByLatestStandby, State.OVERSHADOWED, (Collection<AtomicUpdateGroup<T>>)latestStandby, State.STANDBY);
                    FluentIterable.from(latestStandby).transformAndConcat(group -> this.findOvershadowedBy((AtomicUpdateGroup<T>)group, State.STANDBY)).forEach(aug -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)aug, State.STANDBY, State.OVERSHADOWED));
                } else if (augOfRemovedChunk.isEmpty() && !(latestOvershadowed = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadowedBy(rangeOfAug, minorVersion, State.OVERSHADOWED))).isEmpty()) {
                    latestOvershadowed.forEach(aug -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)aug, State.OVERSHADOWED, State.VISIBLE));
                }
            }
        }
    }

    private List<AtomicUpdateGroup<T>> findLatestNonFullyAvailableAtomicUpdateGroups(List<AtomicUpdateGroup<T>> groups) {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        TreeMap<RootPartitionRange, AtomicUpdateGroup<T>> rangeToGroup = new TreeMap<RootPartitionRange, AtomicUpdateGroup<T>>();
        for (AtomicUpdateGroup<T> group : groups) {
            rangeToGroup.put(RootPartitionRange.of(group), group);
        }
        ArrayList<AtomicUpdateGroup<T>> visibles = new ArrayList<AtomicUpdateGroup<T>>();
        Map.Entry currEntry = rangeToGroup.lastEntry();
        while (currEntry != null) {
            Map.Entry lowerEntry = rangeToGroup.lowerEntry((RootPartitionRange)currEntry.getKey());
            if (lowerEntry != null && ((RootPartitionRange)lowerEntry.getKey()).endPartitionId != ((RootPartitionRange)currEntry.getKey()).startPartitionId) {
                return Collections.emptyList();
            }
            visibles.add((AtomicUpdateGroup<T>)currEntry.getValue());
            currEntry = lowerEntry;
        }
        visibles.sort(Comparator.comparing(x$0 -> RootPartitionRange.of(x$0)));
        return visibles;
    }

    private List<AtomicUpdateGroup<T>> findLatestFullyAvailableOvershadowedAtomicUpdateGroups(RootPartitionRange rangeOfAug, short minorVersion) {
        List<AtomicUpdateGroup<T>> overshadowedGroups = this.findOvershadowedBy(rangeOfAug, minorVersion, State.OVERSHADOWED);
        TreeMap<RootPartitionRange, AtomicUpdateGroup> fullGroups = new TreeMap<RootPartitionRange, AtomicUpdateGroup>();
        for (AtomicUpdateGroup group : FluentIterable.from(overshadowedGroups).filter(AtomicUpdateGroup::isFull)) {
            fullGroups.put(RootPartitionRange.of(group), group);
        }
        if (fullGroups.isEmpty()) {
            return Collections.emptyList();
        }
        if (((RootPartitionRange)fullGroups.firstKey()).startPartitionId != rangeOfAug.startPartitionId || ((RootPartitionRange)fullGroups.lastKey()).endPartitionId != rangeOfAug.endPartitionId) {
            return Collections.emptyList();
        }
        ArrayList<AtomicUpdateGroup<T>> visibles = new ArrayList<AtomicUpdateGroup<T>>();
        Map.Entry currEntry = fullGroups.lastEntry();
        while (currEntry != null) {
            Map.Entry lowerEntry = fullGroups.lowerEntry((RootPartitionRange)currEntry.getKey());
            if (lowerEntry != null && ((RootPartitionRange)lowerEntry.getKey()).endPartitionId != ((RootPartitionRange)currEntry.getKey()).startPartitionId) {
                return Collections.emptyList();
            }
            visibles.add((AtomicUpdateGroup<T>)currEntry.getValue());
            currEntry = lowerEntry;
        }
        visibles.sort(Comparator.comparing(x$0 -> RootPartitionRange.of(x$0)));
        return visibles;
    }

    private void removeFrom(AtomicUpdateGroup<T> aug, State state) {
        RootPartitionRange rangeKey = RootPartitionRange.of(aug);
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(rangeKey);
        if (versionToGroup == null) {
            throw new ISE("Unknown atomicUpdateGroup[%s] in state[%s]", new Object[]{aug, state});
        }
        AtomicUpdateGroup removed = (AtomicUpdateGroup)versionToGroup.remove(aug.getMinorVersion());
        if (removed == null) {
            throw new ISE("Unknown atomicUpdateGroup[%s] in state[%s]", new Object[]{aug, state});
        }
        if (!removed.equals(aug)) {
            throw new ISE("Unexpected state: Removed atomicUpdateGroup[%s] is different from expected atomicUpdateGroup[%s]", removed, aug);
        }
        if (versionToGroup.isEmpty()) {
            this.getStateMap(state).remove(rangeKey);
        }
    }

    @Nullable
    PartitionChunk<T> removeChunk(PartitionChunk<T> partitionChunk) {
        PartitionChunk<T> knownChunk = this.knownPartitionChunks.get(partitionChunk.getChunkNumber());
        if (knownChunk == null) {
            return null;
        }
        if (!knownChunk.equals(partitionChunk)) {
            throw new ISE("Unexpected state: Same partitionId[%d], but known partition[%s] is different from the input partition[%s]", partitionChunk.getChunkNumber(), knownChunk, partitionChunk);
        }
        AtomicUpdateGroup<T> augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.STANDBY);
        if (augOfRemovedChunk == null && (augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.VISIBLE)) == null && (augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.OVERSHADOWED)) == null) {
            throw new ISE("Can't find atomicUpdateGroup for partitionChunk[%s]", partitionChunk);
        }
        return this.knownPartitionChunks.remove(partitionChunk.getChunkNumber());
    }

    public boolean isEmpty() {
        return this.visibleGroupPerRange.isEmpty();
    }

    public boolean isComplete() {
        return Iterators.all(this.visibleGroupPerRange.values().iterator(), map -> {
            SingleEntryShort2ObjectSortedMap singleMap = (SingleEntryShort2ObjectSortedMap)((Object)map);
            return ((AtomicUpdateGroup)singleMap.val).isFull();
        });
    }

    @Nullable
    PartitionChunk<T> getChunk(int partitionId) {
        PartitionChunk<T> chunk = this.knownPartitionChunks.get(partitionId);
        if (chunk == null) {
            return null;
        }
        AtomicUpdateGroup<T> aug = this.findAtomicUpdateGroupWith(chunk, State.VISIBLE);
        if (aug == null) {
            return null;
        }
        return (PartitionChunk)Preconditions.checkNotNull(aug.findChunk(partitionId), (String)"Can't find partitionChunk for partitionId[%s] in atomicUpdateGroup[%s]", (Object[])new Object[]{partitionId, aug});
    }

    Iterator<PartitionChunk<T>> visibleChunksIterator() {
        FluentIterable versionToGroupIterable = FluentIterable.from(this.visibleGroupPerRange.values());
        return versionToGroupIterable.transformAndConcat(map -> {
            SingleEntryShort2ObjectSortedMap singleMap = (SingleEntryShort2ObjectSortedMap)((Object)map);
            return ((AtomicUpdateGroup)singleMap.val).getChunks();
        }).iterator();
    }

    List<PartitionChunk<T>> getOvershadowedChunks() {
        return OvershadowableManager.getAllChunks(this.overshadowedGroups);
    }

    @VisibleForTesting
    List<PartitionChunk<T>> getStandbyChunks() {
        return OvershadowableManager.getAllChunks(this.standbyGroups);
    }

    private static <T extends Overshadowable<T>> List<PartitionChunk<T>> getAllChunks(TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap) {
        ArrayList<PartitionChunk<T>> allChunks = new ArrayList<PartitionChunk<T>>();
        for (Short2ObjectSortedMap<AtomicUpdateGroup<T>> treeMap : stateMap.values()) {
            for (AtomicUpdateGroup aug : treeMap.values()) {
                allChunks.addAll(aug.getChunks());
            }
        }
        return allChunks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OvershadowableManager that = (OvershadowableManager)o;
        return Objects.equals(this.knownPartitionChunks, that.knownPartitionChunks) && Objects.equals(this.standbyGroups, that.standbyGroups) && Objects.equals(this.visibleGroupPerRange, that.visibleGroupPerRange) && Objects.equals(this.overshadowedGroups, that.overshadowedGroups);
    }

    public int hashCode() {
        return Objects.hash(this.knownPartitionChunks, this.standbyGroups, this.visibleGroupPerRange, this.overshadowedGroups);
    }

    public String toString() {
        return "OvershadowableManager{knownPartitionChunks=" + this.knownPartitionChunks + ", standbyGroups=" + this.standbyGroups + ", visibleGroupPerRangePerVersion=" + this.visibleGroupPerRange + ", overshadowedGroups=" + this.overshadowedGroups + '}';
    }

    private static class SingleEntryShort2ObjectSortedMap<V>
    extends AbstractShort2ObjectSortedMap<V> {
        private short key;
        private V val;

        private SingleEntryShort2ObjectSortedMap() {
            this.key = (short)-1;
            this.val = null;
        }

        private SingleEntryShort2ObjectSortedMap(short key, V val) {
            this.key = key;
            this.val = val;
        }

        public Short2ObjectSortedMap<V> subMap(short fromKey, short toKey) {
            if (fromKey <= this.key && toKey > this.key) {
                return this;
            }
            throw new IAE("fromKey: %s, toKey: %s, key: %s", fromKey, toKey, this.key);
        }

        public Short2ObjectSortedMap<V> headMap(short toKey) {
            if (toKey > this.key) {
                return this;
            }
            throw new IAE("toKey: %s, key: %s", toKey, this.key);
        }

        public Short2ObjectSortedMap<V> tailMap(short fromKey) {
            if (fromKey <= this.key) {
                return this;
            }
            throw new IAE("fromKey: %s, key: %s", fromKey, this.key);
        }

        public short firstShortKey() {
            if (this.key < 0) {
                throw new NoSuchElementException();
            }
            return this.key;
        }

        public short lastShortKey() {
            if (this.key < 0) {
                throw new NoSuchElementException();
            }
            return this.key;
        }

        public ObjectSortedSet<Short2ObjectMap.Entry<V>> short2ObjectEntrySet() {
            return this.isEmpty() ? ObjectSortedSets.EMPTY_SET : ObjectSortedSets.singleton((Object)new AbstractShort2ObjectMap.BasicEntry(this.key, this.val));
        }

        public ShortSortedSet keySet() {
            return this.isEmpty() ? ShortSortedSets.EMPTY_SET : ShortSortedSets.singleton((short)this.key);
        }

        public ObjectCollection<V> values() {
            return new AbstractObjectCollection<V>(){

                public ObjectIterator<V> iterator() {
                    return this.size() > 0 ? ObjectIterators.singleton((Object)val) : ObjectIterators.emptyIterator();
                }

                public int size() {
                    return key < 0 ? 0 : 1;
                }
            };
        }

        public V put(short key, V value) {
            if (this.isEmpty()) {
                this.key = key;
                this.val = value;
                return null;
            }
            if (this.key == key) {
                V existing = this.val;
                this.val = value;
                return existing;
            }
            throw new ISE("Can't add [%d, %s] to non-empty SingleEntryShort2ObjectSortedMap[%d, %s]", key, value, this.key, this.val);
        }

        public V get(short key) {
            return this.key == key ? (V)this.val : null;
        }

        public V remove(short key) {
            if (this.key == key) {
                this.key = (short)-1;
                return this.val;
            }
            return null;
        }

        public boolean containsKey(short key) {
            return this.key == key;
        }

        public ShortComparator comparator() {
            return ShortComparators.NATURAL_COMPARATOR;
        }

        public int size() {
            return this.key < 0 ? 0 : 1;
        }

        public void defaultReturnValue(V rv) {
            throw new UnsupportedOperationException();
        }

        public V defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.key < 0;
        }

        public boolean containsValue(Object value) {
            if (this.key < 0) {
                return false;
            }
            return Objects.equals(this.val, value);
        }

        public void putAll(Map<? extends Short, ? extends V> m) {
            if (!m.isEmpty()) {
                if (m.size() == 1) {
                    Map.Entry<Short, V> entry = m.entrySet().iterator().next();
                    this.key = entry.getKey();
                    this.val = entry.getValue();
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    @VisibleForTesting
    static class RootPartitionRange
    implements Comparable<RootPartitionRange> {
        private final short startPartitionId;
        private final short endPartitionId;

        @VisibleForTesting
        static RootPartitionRange of(int startPartitionId, int endPartitionId) {
            return new RootPartitionRange((short)startPartitionId, (short)endPartitionId);
        }

        private static <T extends Overshadowable<T>> RootPartitionRange of(PartitionChunk<T> chunk) {
            return RootPartitionRange.of(((Overshadowable)chunk.getObject()).getStartRootPartitionId(), ((Overshadowable)chunk.getObject()).getEndRootPartitionId());
        }

        private static <T extends Overshadowable<T>> RootPartitionRange of(AtomicUpdateGroup<T> aug) {
            return RootPartitionRange.of(aug.getStartRootPartitionId(), aug.getEndRootPartitionId());
        }

        private RootPartitionRange(short startPartitionId, short endPartitionId) {
            this.startPartitionId = startPartitionId;
            this.endPartitionId = endPartitionId;
        }

        public boolean contains(RootPartitionRange that) {
            return Short.toUnsignedInt(this.startPartitionId) <= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.endPartitionId) >= Short.toUnsignedInt(that.endPartitionId);
        }

        public boolean overlaps(RootPartitionRange that) {
            return Short.toUnsignedInt(this.startPartitionId) <= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.endPartitionId) > Short.toUnsignedInt(that.startPartitionId) || Short.toUnsignedInt(this.startPartitionId) >= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.startPartitionId) < Short.toUnsignedInt(that.endPartitionId);
        }

        @Override
        public int compareTo(RootPartitionRange o) {
            if (this.startPartitionId != o.startPartitionId) {
                return Integer.compare(Short.toUnsignedInt(this.startPartitionId), Short.toUnsignedInt(o.startPartitionId));
            }
            return Integer.compare(Short.toUnsignedInt(this.endPartitionId), Short.toUnsignedInt(o.endPartitionId));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootPartitionRange that = (RootPartitionRange)o;
            return this.startPartitionId == that.startPartitionId && this.endPartitionId == that.endPartitionId;
        }

        public int hashCode() {
            return Objects.hash(this.startPartitionId, this.endPartitionId);
        }

        public String toString() {
            return "RootPartitionRange{startPartitionId=" + this.startPartitionId + ", endPartitionId=" + this.endPartitionId + '}';
        }
    }

    @VisibleForTesting
    static enum State {
        STANDBY,
        VISIBLE,
        OVERSHADOWED;

    }
}

