/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class VersionedIntervalTimeline<VersionType, ObjectType extends Overshadowable<ObjectType>>
implements TimelineLookup<VersionType, ObjectType> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final NavigableMap<Interval, TimelineEntry> completePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    @VisibleForTesting
    final NavigableMap<Interval, TimelineEntry> incompletePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    private final Map<Interval, TreeMap<VersionType, TimelineEntry>> allTimelineEntries = new HashMap<Interval, TreeMap<VersionType, TimelineEntry>>();
    private final AtomicInteger numObjects = new AtomicInteger();
    private final Comparator<? super VersionType> versionComparator;
    private final boolean skipObjectsWithNoData;

    public VersionedIntervalTimeline(Comparator<? super VersionType> versionComparator) {
        this(versionComparator, false);
    }

    public VersionedIntervalTimeline(Comparator<? super VersionType> versionComparator, boolean skipObjectsWithNoData) {
        this.versionComparator = versionComparator;
        this.skipObjectsWithNoData = skipObjectsWithNoData;
    }

    public static void addSegments(VersionedIntervalTimeline<String, DataSegment> timeline, Iterator<DataSegment> segments) {
        timeline.addAll(Iterators.transform(segments, segment -> new PartitionChunkEntry<String, DataSegment>(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment))));
    }

    public static <VersionType, ObjectType extends Overshadowable<ObjectType>> Iterable<ObjectType> getAllObjects(List<TimelineObjectHolder<VersionType, ObjectType>> holders) {
        return () -> holders.stream().flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false)).map(PartitionChunk::getObject).iterator();
    }

    public Map<Interval, TreeMap<VersionType, TimelineEntry>> getAllTimelineEntries() {
        return this.allTimelineEntries;
    }

    public Collection<ObjectType> iterateAllObjects() {
        return CollectionUtils.createLazyCollectionFromStream(() -> this.allTimelineEntries.values().stream().flatMap(entryMap -> entryMap.values().stream()).flatMap(entry -> StreamSupport.stream(entry.getPartitionHolder().spliterator(), false)).map(PartitionChunk::getObject), this.numObjects.get());
    }

    public int getNumObjects() {
        return this.numObjects.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectType> findNonOvershadowedObjectsInInterval(Interval interval, Partitions completeness) {
        List<TimelineObjectHolder<VersionType, ObjectType>> holders;
        this.lock.readLock().lock();
        try {
            holders = this.lookup(interval, completeness);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return FluentIterable.from(holders).transformAndConcat(TimelineObjectHolder::getObject).transform(PartitionChunk::getObject).toSet();
    }

    public void add(Interval interval, VersionType version, PartitionChunk<ObjectType> object) {
        this.addAll((Iterator<PartitionChunkEntry<VersionType, ObjectType>>)Iterators.singletonIterator(new PartitionChunkEntry<VersionType, ObjectType>(interval, version, object)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterator<PartitionChunkEntry<VersionType, ObjectType>> objects) {
        this.lock.writeLock().lock();
        try {
            Interval interval;
            IdentityHashMap<TimelineEntry, Interval> allEntries = new IdentityHashMap<TimelineEntry, Interval>();
            while (objects.hasNext()) {
                TimelineEntry entry;
                PartitionChunkEntry<VersionType, ObjectType> chunkEntry = objects.next();
                PartitionChunk<ObjectType> object = chunkEntry.getChunk();
                interval = chunkEntry.getInterval();
                VersionType version = chunkEntry.getVersion();
                Map exists = this.allTimelineEntries.get(interval);
                if (exists == null) {
                    entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                    TreeMap<VersionType, TimelineEntry> versionEntry = new TreeMap<VersionType, TimelineEntry>(this.versionComparator);
                    versionEntry.put(version, entry);
                    this.allTimelineEntries.put(interval, versionEntry);
                    this.numObjects.incrementAndGet();
                } else {
                    entry = (TimelineEntry)exists.get(version);
                    if (entry == null) {
                        entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                        exists.put(version, entry);
                        this.numObjects.incrementAndGet();
                    } else {
                        PartitionHolder partitionHolder = entry.getPartitionHolder();
                        if (partitionHolder.add(object)) {
                            this.numObjects.incrementAndGet();
                        }
                    }
                }
                allEntries.put(entry, interval);
            }
            for (Map.Entry entry : allEntries.entrySet()) {
                interval = (Interval)entry.getValue();
                if (((TimelineEntry)entry.getKey()).getPartitionHolder().isComplete()) {
                    this.add(this.completePartitionsTimeline, interval, (TimelineEntry)entry.getKey());
                }
                this.add(this.incompletePartitionsTimeline, interval, (TimelineEntry)entry.getKey());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PartitionChunk<ObjectType> remove(Interval interval, VersionType version, PartitionChunk<ObjectType> chunk) {
        this.lock.writeLock().lock();
        try {
            Map versionEntries = this.allTimelineEntries.get(interval);
            if (versionEntries == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            TimelineEntry entry = (TimelineEntry)versionEntries.get(version);
            if (entry == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            PartitionChunk removedChunk = entry.getPartitionHolder().remove(chunk);
            if (removedChunk == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            this.numObjects.decrementAndGet();
            if (entry.getPartitionHolder().isEmpty()) {
                versionEntries.remove(version);
                if (versionEntries.isEmpty()) {
                    this.allTimelineEntries.remove(interval);
                }
                this.remove(this.incompletePartitionsTimeline, interval, entry, true);
            }
            this.remove(this.completePartitionsTimeline, interval, entry, false);
            PartitionChunk partitionChunk = removedChunk;
            return partitionChunk;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PartitionChunk<ObjectType> findChunk(Interval interval, VersionType version, int partitionNum) {
        this.lock.readLock().lock();
        try {
            for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> entry : this.allTimelineEntries.entrySet()) {
                TimelineEntry foundEntry;
                if (!entry.getKey().equals((Object)interval) && !entry.getKey().contains((ReadableInterval)interval) || (foundEntry = entry.getValue().get(version)) == null) continue;
                PartitionChunk partitionChunk = foundEntry.getPartitionHolder().getChunk(partitionNum);
                return partitionChunk;
            }
            Iterator<Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>>> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval) {
        this.lock.readLock().lock();
        try {
            List<TimelineObjectHolder<VersionType, ObjectType>> list = this.lookup(interval, Partitions.ONLY_COMPLETE);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<TimelineObjectHolder<VersionType, ObjectType>> lookupWithIncompletePartitions(Interval interval) {
        this.lock.readLock().lock();
        try {
            List<TimelineObjectHolder<VersionType, ObjectType>> list = this.lookup(interval, Partitions.INCOMPLETE_OK);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.completePartitionsTimeline.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TimelineObjectHolder<VersionType, ObjectType> first() {
        this.lock.readLock().lock();
        try {
            TimelineObjectHolder<VersionType, ObjectType> timelineObjectHolder = this.timelineEntryToObjectHolder(this.completePartitionsTimeline.firstEntry().getValue());
            return timelineObjectHolder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TimelineObjectHolder<VersionType, ObjectType> last() {
        this.lock.readLock().lock();
        try {
            TimelineObjectHolder<VersionType, ObjectType> timelineObjectHolder = this.timelineEntryToObjectHolder(this.completePartitionsTimeline.lastEntry().getValue());
            return timelineObjectHolder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private TimelineObjectHolder<VersionType, ObjectType> timelineEntryToObjectHolder(TimelineEntry entry) {
        return new TimelineObjectHolder(entry.getTrueInterval(), entry.getTrueInterval(), entry.getVersion(), PartitionHolder.copyWithOnlyVisibleChunks(entry.getPartitionHolder()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TimelineObjectHolder<VersionType, ObjectType>> findFullyOvershadowed() {
        this.lock.readLock().lock();
        try {
            Map<Interval, Map<VersionType, TimelineEntry>> overshadowedPartitionsTimeline = this.computeOvershadowedPartitionsTimeline();
            Set overshadowedObjects = overshadowedPartitionsTimeline.values().stream().flatMap(entry -> entry.values().stream()).map(entry -> new TimelineObjectHolder(entry.getTrueInterval(), entry.getTrueInterval(), entry.getVersion(), PartitionHolder.deepCopy(entry.getPartitionHolder()))).collect(Collectors.toSet());
            for (TimelineEntry entry2 : this.incompletePartitionsTimeline.values()) {
                List overshadowedEntries = entry2.partitionHolder.getOvershadowed();
                if (overshadowedEntries.isEmpty()) continue;
                overshadowedObjects.add(new TimelineObjectHolder(entry2.trueInterval, entry2.version, new PartitionHolder(overshadowedEntries)));
            }
            Set set = overshadowedObjects;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<Interval, Map<VersionType, TimelineEntry>> computeOvershadowedPartitionsTimeline() {
        HashMap overshadowedPartitionsTimeline = new HashMap();
        this.allTimelineEntries.forEach((interval, versionEntry) -> {
            TreeMap versionEntryCopy = (TreeMap)versionEntry.clone();
            overshadowedPartitionsTimeline.put((Interval)interval, versionEntryCopy);
        });
        for (TimelineEntry entry : this.completePartitionsTimeline.values()) {
            overshadowedPartitionsTimeline.computeIfPresent(entry.getTrueInterval(), (interval, versionEntry) -> {
                versionEntry.remove(entry.getVersion());
                return versionEntry.isEmpty() ? null : versionEntry;
            });
        }
        for (TimelineEntry entry : this.incompletePartitionsTimeline.values()) {
            overshadowedPartitionsTimeline.computeIfPresent(entry.getTrueInterval(), (interval, versionEntry) -> {
                versionEntry.remove(entry.getVersion());
                return versionEntry.isEmpty() ? null : versionEntry;
            });
        }
        return overshadowedPartitionsTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOvershadowed(Interval interval, VersionType version, ObjectType object) {
        this.lock.readLock().lock();
        try {
            TimelineEntry entry = (TimelineEntry)this.completePartitionsTimeline.get(interval);
            if (entry != null) {
                int majorVersionCompare = this.versionComparator.compare(version, entry.getVersion());
                if (majorVersionCompare == 0) {
                    for (PartitionChunk chunk2 : entry.partitionHolder) {
                        if (!((Overshadowable)chunk2.getObject()).overshadows(object)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = majorVersionCompare < 0;
                return bl;
            }
            Interval lower = this.completePartitionsTimeline.floorKey(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)DateTimes.MAX));
            if (lower == null || !lower.overlaps((ReadableInterval)interval)) {
                boolean bl = false;
                return bl;
            }
            Interval prev = null;
            Interval curr = lower;
            do {
                boolean nonOvershadowedObject;
                if (curr == null || prev != null && curr.getStartMillis() > prev.getEndMillis()) {
                    boolean bl = false;
                    return bl;
                }
                TimelineEntry timelineEntry = (TimelineEntry)this.completePartitionsTimeline.get(curr);
                int versionCompare = this.versionComparator.compare(version, timelineEntry.getVersion());
                if (versionCompare > 0) {
                    boolean bl = false;
                    return bl;
                }
                if (versionCompare == 0 && (nonOvershadowedObject = Iterators.all(timelineEntry.partitionHolder.iterator(), chunk -> !((Overshadowable)chunk.getObject()).overshadows(object)))) {
                    boolean bl = false;
                    return bl;
                }
                prev = curr;
                curr = this.completePartitionsTimeline.higherKey(curr);
            } while (interval.getEndMillis() > prev.getEndMillis());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @GuardedBy(value="lock")
    private void add(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry) {
        TimelineEntry existsInTimeline = (TimelineEntry)timeline.get(interval);
        if (existsInTimeline != null) {
            int compare = this.versionComparator.compare(entry.getVersion(), existsInTimeline.getVersion());
            if (compare > 0) {
                this.addIntervalToTimeline(interval, entry, timeline);
            }
            return;
        }
        Interval lowerKey = timeline.lowerKey(interval);
        if (lowerKey != null && this.addAtKey(timeline, lowerKey, entry)) {
            return;
        }
        Interval higherKey = timeline.higherKey(interval);
        if (higherKey != null && this.addAtKey(timeline, higherKey, entry)) {
            return;
        }
        this.addIntervalToTimeline(interval, entry, timeline);
    }

    @GuardedBy(value="lock")
    private boolean addAtKey(NavigableMap<Interval, TimelineEntry> timeline, Interval key, TimelineEntry entry) {
        boolean retVal = false;
        Interval currKey = key;
        Object entryInterval = entry.getTrueInterval();
        if (!currKey.overlaps((ReadableInterval)entryInterval)) {
            return false;
        }
        while (entryInterval != null && currKey != null && currKey.overlaps((ReadableInterval)entryInterval)) {
            Interval nextKey = timeline.higherKey(currKey);
            int versionCompare = this.versionComparator.compare(entry.getVersion(), ((TimelineEntry)timeline.get(currKey)).getVersion());
            if (versionCompare < 0) {
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    entryInterval = new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd());
                } else {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getStart(), (ReadableInstant)currKey.getStart()), entry, timeline);
                    entryInterval = entryInterval.getEnd().isAfter((ReadableInstant)currKey.getEnd()) ? new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd()) : null;
                }
            } else if (versionCompare > 0) {
                TimelineEntry oldEntry = (TimelineEntry)timeline.remove(currKey);
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                    this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                } else if (entryInterval.getEnd().isBefore((ReadableInstant)currKey.getEnd())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                }
            } else if (((TimelineEntry)timeline.get(currKey)).equals(entry)) {
                timeline.remove(currKey);
            } else {
                throw new UOE("Cannot add overlapping segments [%s and %s] with the same version [%s]", currKey, entryInterval, entry.getVersion());
            }
            currKey = nextKey;
            retVal = true;
        }
        this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
        return retVal;
    }

    @GuardedBy(value="lock")
    private void addIntervalToTimeline(Interval interval, TimelineEntry entry, NavigableMap<Interval, TimelineEntry> timeline) {
        if (interval != null && interval.toDurationMillis() > 0L) {
            timeline.put(interval, entry);
        }
    }

    @GuardedBy(value="lock")
    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry, boolean incompleteOk) {
        ArrayList<Object> intervalsToRemove = new ArrayList<Object>();
        TimelineEntry removed = (TimelineEntry)timeline.get(interval);
        if (removed == null) {
            for (Map.Entry entry2 : timeline.entrySet()) {
                if (entry2.getValue() != entry) continue;
                intervalsToRemove.add(entry2.getKey());
            }
        } else {
            intervalsToRemove.add(interval);
        }
        for (Interval interval2 : intervalsToRemove) {
            this.remove(timeline, interval2, incompleteOk);
        }
    }

    @GuardedBy(value="lock")
    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, boolean incompleteOk) {
        timeline.remove(interval);
        block0: for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> versionEntry : this.allTimelineEntries.entrySet()) {
            if (versionEntry.getKey().overlap((ReadableInterval)interval) == null) continue;
            if (incompleteOk) {
                this.add(timeline, versionEntry.getKey(), versionEntry.getValue().lastEntry().getValue());
                continue;
            }
            for (VersionType ver : versionEntry.getValue().descendingKeySet()) {
                TimelineEntry timelineEntry = versionEntry.getValue().get(ver);
                if (!timelineEntry.getPartitionHolder().isComplete()) continue;
                this.add(timeline, versionEntry.getKey(), timelineEntry);
                continue block0;
            }
        }
    }

    @GuardedBy(value="lock")
    private List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval, Partitions completeness) {
        TimelineObjectHolder lastEntry;
        ArrayList<TimelineObjectHolder<VersionType, ObjectType>> retVal = new ArrayList<TimelineObjectHolder<VersionType, ObjectType>>();
        NavigableMap<Interval, TimelineEntry> timeline = completeness == Partitions.INCOMPLETE_OK ? this.incompletePartitionsTimeline : this.completePartitionsTimeline;
        for (Map.Entry entry : timeline.entrySet()) {
            Interval timelineInterval = (Interval)entry.getKey();
            TimelineEntry val = (TimelineEntry)entry.getValue();
            if (this.skipObjectsWithNoData && !val.partitionHolder.hasData() || !timelineInterval.overlaps((ReadableInterval)interval)) continue;
            retVal.add(new TimelineObjectHolder(timelineInterval, val.getTrueInterval(), val.getVersion(), PartitionHolder.copyWithOnlyVisibleChunks(val.getPartitionHolder())));
        }
        if (retVal.isEmpty()) {
            return retVal;
        }
        TimelineObjectHolder firstEntry = (TimelineObjectHolder)retVal.get(0);
        if (interval.overlaps((ReadableInterval)firstEntry.getInterval()) && interval.getStart().isAfter((ReadableInstant)firstEntry.getInterval().getStart())) {
            retVal.set(0, new TimelineObjectHolder(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)firstEntry.getInterval().getEnd()), firstEntry.getTrueInterval(), firstEntry.getVersion(), firstEntry.getObject()));
        }
        if (interval.overlaps((ReadableInterval)(lastEntry = (TimelineObjectHolder)retVal.get(retVal.size() - 1)).getInterval()) && interval.getEnd().isBefore((ReadableInstant)lastEntry.getInterval().getEnd())) {
            retVal.set(retVal.size() - 1, new TimelineObjectHolder(new Interval((ReadableInstant)lastEntry.getInterval().getStart(), (ReadableInstant)interval.getEnd()), lastEntry.getTrueInterval(), lastEntry.getVersion(), lastEntry.getObject()));
        }
        return retVal;
    }

    public static class PartitionChunkEntry<VersionType, ObjectType> {
        private final Interval interval;
        private final VersionType version;
        private final PartitionChunk<ObjectType> chunk;

        public PartitionChunkEntry(Interval interval, VersionType version, PartitionChunk<ObjectType> chunk) {
            this.interval = interval;
            this.version = version;
            this.chunk = chunk;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public VersionType getVersion() {
            return this.version;
        }

        public PartitionChunk<ObjectType> getChunk() {
            return this.chunk;
        }
    }

    public class TimelineEntry {
        private final Interval trueInterval;
        private final VersionType version;
        private final PartitionHolder<ObjectType> partitionHolder;

        TimelineEntry(Interval trueInterval, VersionType version, PartitionHolder<ObjectType> partitionHolder) {
            this.trueInterval = (Interval)Preconditions.checkNotNull((Object)trueInterval);
            this.version = Preconditions.checkNotNull(version);
            this.partitionHolder = (PartitionHolder)Preconditions.checkNotNull(partitionHolder);
        }

        Interval getTrueInterval() {
            return this.trueInterval;
        }

        public VersionType getVersion() {
            return this.version;
        }

        public PartitionHolder<ObjectType> getPartitionHolder() {
            return this.partitionHolder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimelineEntry that = (TimelineEntry)o;
            if (!this.trueInterval.equals((Object)that.trueInterval)) {
                return false;
            }
            if (!this.version.equals(that.version)) {
                return false;
            }
            return this.partitionHolder.equals(that.partitionHolder);
        }

        public int hashCode() {
            return Objects.hash(this.trueInterval, this.version, this.partitionHolder);
        }
    }
}

