/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.StorageConnector;

public class LocalFileStorageConnector
implements StorageConnector {
    private final File basePath;

    public LocalFileStorageConnector(File basePath) throws IOException {
        this.basePath = basePath;
        FileUtils.mkdirp(basePath);
    }

    @Override
    public boolean pathExists(String path) {
        return this.fileWithBasePath(path).exists();
    }

    @Override
    public InputStream read(String path) throws IOException {
        return Files.newInputStream(this.fileWithBasePath(path).toPath(), new OpenOption[0]);
    }

    @Override
    public OutputStream write(String path) throws IOException {
        File toWrite = this.fileWithBasePath(path);
        FileUtils.mkdirp(toWrite.getParentFile());
        return Files.newOutputStream(toWrite.toPath(), new OpenOption[0]);
    }

    @Override
    public void deleteFile(String path) throws IOException {
        File toDelete = this.fileWithBasePath(path);
        if (toDelete.isDirectory()) {
            throw new IAE(StringUtils.format("Found a directory on path[%s]. Please use deleteRecusively to delete dirs", path), new Object[0]);
        }
        Files.delete(this.fileWithBasePath(path).toPath());
    }

    @Override
    public void deleteRecursively(String dirName) throws IOException {
        FileUtils.deleteDirectory(this.fileWithBasePath(dirName));
    }

    @Override
    public List<String> listDir(String dirName) {
        File directory = this.fileWithBasePath(dirName);
        if (!directory.exists()) {
            throw new IAE("No directory exists on path [%s]", dirName);
        }
        if (!directory.isDirectory()) {
            throw new IAE("Cannot list contents of [%s] since it is not a directory", dirName);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new ISE("Unable to fetch the file list from the path [%s]", dirName);
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public File getBasePath() {
        return this.basePath;
    }

    private File fileWithBasePath(String path) {
        return new File(this.basePath, path);
    }
}

