/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeFactory;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.ValueType;

public class ColumnTypeFactory
implements TypeFactory<ColumnType> {
    private static final ColumnTypeFactory INSTANCE = new ColumnTypeFactory();
    private static final Interner<ColumnType> INTERNER = Interners.newWeakInterner();

    public static TypeFactory<ColumnType> getInstance() {
        return INSTANCE;
    }

    private ColumnTypeFactory() {
    }

    public static ColumnType ofType(TypeSignature<ValueType> type) {
        switch (type.getType()) {
            case LONG: {
                return ColumnType.LONG;
            }
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case STRING: {
                return ColumnType.STRING;
            }
            case ARRAY: {
                switch (type.getElementType().getType()) {
                    case LONG: {
                        return ColumnType.LONG_ARRAY;
                    }
                    case DOUBLE: {
                        return ColumnType.DOUBLE_ARRAY;
                    }
                    case STRING: {
                        return ColumnType.STRING_ARRAY;
                    }
                }
                throw new ISE("Unsupported expression type[%s]", type.asTypeString());
            }
            case COMPLEX: {
                return (ColumnType)INTERNER.intern((Object)new ColumnType(ValueType.COMPLEX, type.getComplexTypeName(), null));
            }
        }
        throw new ISE("Unsupported column type[%s]", type.asTypeString());
    }

    public static ColumnType ofValueType(ValueType type) {
        switch (type) {
            case LONG: {
                return ColumnType.LONG;
            }
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case STRING: {
                return ColumnType.STRING;
            }
            case COMPLEX: {
                return ColumnType.UNKNOWN_COMPLEX;
            }
        }
        throw new ISE("Unsupported column type[%s]", type);
    }

    @Override
    public <T> TypeStrategy<T> getTypeStrategy(ColumnType type) {
        TypeStrategy<Long> strategy;
        switch ((ValueType)type.getType()) {
            case LONG: {
                strategy = TypeStrategies.LONG;
                break;
            }
            case FLOAT: {
                strategy = TypeStrategies.FLOAT;
                break;
            }
            case DOUBLE: {
                strategy = TypeStrategies.DOUBLE;
                break;
            }
            case STRING: {
                strategy = TypeStrategies.STRING;
                break;
            }
            case ARRAY: {
                strategy = new TypeStrategies.ArrayTypeStrategy(type);
                break;
            }
            case COMPLEX: {
                TypeStrategy<?> complexStrategy = TypeStrategies.getComplex(type.getComplexTypeName());
                if (complexStrategy == null) {
                    throw new IAE("Cannot find strategy for type [%s]", type.asTypeString());
                }
                strategy = complexStrategy;
                break;
            }
            default: {
                throw new ISE("Unsupported column type[%s]", type);
            }
        }
        return strategy;
    }

    @Override
    public ColumnType ofString() {
        return ColumnType.STRING;
    }

    @Override
    public ColumnType ofFloat() {
        return ColumnType.FLOAT;
    }

    @Override
    public ColumnType ofDouble() {
        return ColumnType.DOUBLE;
    }

    @Override
    public ColumnType ofLong() {
        return ColumnType.LONG;
    }

    @Override
    public ColumnType ofArray(ColumnType elementType) {
        if (elementType.isPrimitive()) {
            switch ((ValueType)elementType.getType()) {
                case STRING: {
                    return ColumnType.STRING_ARRAY;
                }
                case DOUBLE: {
                    return ColumnType.DOUBLE_ARRAY;
                }
                case LONG: {
                    return ColumnType.LONG_ARRAY;
                }
            }
        }
        return (ColumnType)INTERNER.intern((Object)new ColumnType(ValueType.ARRAY, null, elementType));
    }

    @Override
    public ColumnType ofComplex(@Nullable String complexTypeName) {
        if (complexTypeName == null) {
            return ColumnType.UNKNOWN_COMPLEX;
        }
        return (ColumnType)INTERNER.intern((Object)new ColumnType(ValueType.COMPLEX, complexTypeName, null));
    }
}

