/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.BaseTypeSignature;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;

@JsonSerialize(using=ToStringSerializer.class)
public class ColumnType
extends BaseTypeSignature<ValueType> {
    public static final ColumnType STRING = new ColumnType(ValueType.STRING, null, null);
    public static final ColumnType LONG = new ColumnType(ValueType.LONG, null, null);
    public static final ColumnType DOUBLE = new ColumnType(ValueType.DOUBLE, null, null);
    public static final ColumnType FLOAT = new ColumnType(ValueType.FLOAT, null, null);
    public static final ColumnType STRING_ARRAY = new ColumnType(ValueType.ARRAY, null, STRING);
    public static final ColumnType LONG_ARRAY = new ColumnType(ValueType.ARRAY, null, LONG);
    public static final ColumnType DOUBLE_ARRAY = new ColumnType(ValueType.ARRAY, null, DOUBLE);
    public static final ColumnType FLOAT_ARRAY = new ColumnType(ValueType.ARRAY, null, FLOAT);
    public static final ColumnType UNKNOWN_COMPLEX = new ColumnType(ValueType.COMPLEX, null, null);

    @JsonCreator
    public ColumnType(@JsonProperty(value="type") ValueType type, @JsonProperty(value="complexTypeName") @Nullable String complexTypeName, @JsonProperty(value="elementType") @Nullable ColumnType elementType) {
        super(ColumnTypeFactory.getInstance(), type, complexTypeName, elementType);
    }

    @Nullable
    @JsonCreator
    public static ColumnType fromString(@Nullable String typeName) {
        return Types.fromString(ColumnTypeFactory.getInstance(), typeName);
    }

    public static ColumnType ofArray(ColumnType elementType) {
        return ColumnTypeFactory.getInstance().ofArray(elementType);
    }

    public static ColumnType ofComplex(@Nullable String complexTypeName) {
        return ColumnTypeFactory.getInstance().ofComplex(complexTypeName);
    }
}

