/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.exception.SanitizableException;

public class QueryException
extends RuntimeException
implements SanitizableException {
    private final String errorCode;
    private final String errorClass;
    private final String host;

    protected QueryException(Throwable cause, String errorCode, String errorClass, String host) {
        super(cause == null ? null : cause.getMessage(), cause);
        this.errorCode = errorCode;
        this.errorClass = errorClass;
        this.host = host;
    }

    @JsonCreator
    @VisibleForTesting
    public QueryException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorClass = errorClass;
        this.host = host;
    }

    @Nullable
    @JsonProperty(value="error")
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public String getMessage() {
        return super.getMessage();
    }

    @JsonProperty
    public String getErrorClass() {
        return this.errorClass;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Nullable
    protected static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public QueryException sanitize(@NotNull Function<String, String> errorMessageTransformFunction) {
        return new QueryException(this.errorCode, errorMessageTransformFunction.apply(this.getMessage()), null, null);
    }
}

