/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public interface TaskLookup {
    public TaskLookupType getType();

    public static class ActiveTaskLookup
    implements TaskLookup {
        private static final ActiveTaskLookup INSTANCE = new ActiveTaskLookup();

        public static ActiveTaskLookup getInstance() {
            return INSTANCE;
        }

        private ActiveTaskLookup() {
        }

        @Override
        public TaskLookupType getType() {
            return TaskLookupType.ACTIVE;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActiveTaskLookup;
        }
    }

    public static class CompleteTaskLookup
    implements TaskLookup {
        @Nullable
        private final Integer maxTaskStatuses;
        @Nullable
        private final DateTime tasksCreatedPriorTo;

        public static CompleteTaskLookup of(@Nullable Integer maxTaskStatuses, @Nullable Duration durationBeforeNow) {
            return new CompleteTaskLookup(maxTaskStatuses, durationBeforeNow == null ? null : CompleteTaskLookup.computeTimestampPriorToNow(durationBeforeNow));
        }

        @VisibleForTesting
        public static CompleteTaskLookup withTasksCreatedPriorTo(@Nullable Integer maxTaskStatuses, @Nullable DateTime tasksCreatedPriorTo) {
            return new CompleteTaskLookup(maxTaskStatuses, tasksCreatedPriorTo);
        }

        private CompleteTaskLookup(@Nullable Integer maxTaskStatuses, @Nullable DateTime tasksCreatedPriorTo) {
            this.maxTaskStatuses = maxTaskStatuses;
            this.tasksCreatedPriorTo = tasksCreatedPriorTo;
        }

        public boolean hasTaskCreatedTimeFilter() {
            return this.tasksCreatedPriorTo != null;
        }

        public CompleteTaskLookup withDurationBeforeNow(Duration durationBeforeNow) {
            return CompleteTaskLookup.of(this.maxTaskStatuses, (Duration)Preconditions.checkNotNull((Object)durationBeforeNow, (Object)"durationBeforeNow"));
        }

        private static DateTime computeTimestampPriorToNow(Duration durationBeforeNow) {
            return DateTimes.nowUtc().minus((ReadableDuration)durationBeforeNow);
        }

        public DateTime getTasksCreatedPriorTo() {
            assert (this.tasksCreatedPriorTo != null);
            return this.tasksCreatedPriorTo;
        }

        @Nullable
        public Integer getMaxTaskStatuses() {
            return this.maxTaskStatuses;
        }

        @Override
        public TaskLookupType getType() {
            return TaskLookupType.COMPLETE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompleteTaskLookup that = (CompleteTaskLookup)o;
            return Objects.equals(this.maxTaskStatuses, that.maxTaskStatuses) && Objects.equals(this.tasksCreatedPriorTo, that.tasksCreatedPriorTo);
        }

        public int hashCode() {
            return Objects.hash(this.maxTaskStatuses, this.tasksCreatedPriorTo);
        }
    }

    public static enum TaskLookupType {
        ACTIVE,
        COMPLETE;

    }
}

