/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.PasswordProvider;

public class MetadataStorageConnectorConfig {
    public static final String PROPERTY_BASE = "druid.metadata.storage.connector";
    @JsonProperty
    private boolean createTables = true;
    @JsonProperty
    private String host = "localhost";
    @JsonProperty
    private int port = 1527;
    @JsonProperty
    private String connectURI;
    @JsonProperty
    private String user = null;
    @JsonProperty(value="password")
    private PasswordProvider passwordProvider;
    @JsonProperty(value="dbcp")
    private Properties dbcpProperties;

    public static MetadataStorageConnectorConfig create(String connectUri, String user, String password, Map<String, Object> properties) {
        MetadataStorageConnectorConfig config = new MetadataStorageConnectorConfig();
        if (connectUri != null) {
            config.connectURI = connectUri;
        }
        if (user != null) {
            config.user = user;
        }
        if (password != null) {
            config.passwordProvider = () -> password;
        }
        if (properties != null) {
            config.dbcpProperties = new Properties();
            config.dbcpProperties.putAll(properties);
        }
        return config;
    }

    @JsonProperty
    public boolean isCreateTables() {
        return this.createTables;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getConnectURI() {
        if (this.connectURI == null) {
            return StringUtils.format("jdbc:derby://%s:%s/druid;create=true", this.host, this.port);
        }
        return this.connectURI;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public String getPassword() {
        return this.passwordProvider == null ? null : this.passwordProvider.getPassword();
    }

    @JsonProperty(value="dbcp")
    public Properties getDbcpProperties() {
        return this.dbcpProperties;
    }

    public String toString() {
        return "DbConnectorConfig{createTables=" + this.createTables + ", connectURI='" + this.getConnectURI() + '\'' + ", user='" + this.user + '\'' + ", passwordProvider=" + this.passwordProvider + ", dbcpProperties=" + this.dbcpProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataStorageConnectorConfig)) {
            return false;
        }
        MetadataStorageConnectorConfig that = (MetadataStorageConnectorConfig)o;
        if (this.isCreateTables() != that.isCreateTables()) {
            return false;
        }
        if (this.getPort() != that.getPort()) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(that.getHost()) : that.getHost() != null) {
            return false;
        }
        if (this.getConnectURI() != null ? !this.getConnectURI().equals(that.getConnectURI()) : that.getConnectURI() != null) {
            return false;
        }
        if (this.getUser() != null ? !this.getUser().equals(that.getUser()) : that.getUser() != null) {
            return false;
        }
        if (this.getDbcpProperties() == null ? that.getDbcpProperties() != null : !this.getDbcpProperties().equals(that.getDbcpProperties())) {
            return false;
        }
        return this.passwordProvider != null ? this.passwordProvider.equals(that.passwordProvider) : that.passwordProvider == null;
    }

    public int hashCode() {
        int result = this.isCreateTables() ? 1 : 0;
        result = 31 * result + (this.getHost() != null ? this.getHost().hashCode() : 0);
        result = 31 * result + this.getPort();
        result = 31 * result + (this.getConnectURI() != null ? this.getConnectURI().hashCode() : 0);
        result = 31 * result + (this.getUser() != null ? this.getUser().hashCode() : 0);
        result = 31 * result + (this.passwordProvider != null ? this.passwordProvider.hashCode() : 0);
        result = 31 * result + (this.dbcpProperties != null ? this.dbcpProperties.hashCode() : 0);
        return result;
    }
}

