/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.vector.BivariateFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.DoubleOutDoubleInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongOutDoubleInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutLongInFunctionVectorValueProcessor;
import org.apache.druid.math.expr.vector.LongOutObjectInFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.SymmetricalBivariateFunctionVectorProcessor;
import org.apache.druid.segment.column.Types;

public class VectorProcessors {
    public static <T> ExprVectorProcessor<T> makeSymmetricalProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right, Supplier<ExprVectorProcessor<?>> longProcessor, Supplier<ExprVectorProcessor<?>> doubleProcessor, Supplier<ExprVectorProcessor<?>> stringProcessor) {
        ExpressionType leftType = left.getOutputType(inspector);
        if (leftType == null) {
            return right.buildVectorized(inspector);
        }
        Preconditions.checkArgument((boolean)inspector.areSameTypes(left, right), (String)"%s and %s are not the same type", (Object[])new Object[]{leftType, right.getOutputType(inspector)});
        ExprVectorProcessor<?> processor = null;
        if (Types.is(leftType, ExprType.STRING)) {
            processor = stringProcessor.get();
        } else if (Types.is(leftType, ExprType.LONG)) {
            processor = longProcessor.get();
        } else if (Types.is(leftType, ExprType.DOUBLE)) {
            processor = doubleProcessor.get();
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable String constant, int maxVectorSize) {
        Object[] strings = new Object[maxVectorSize];
        Arrays.fill(strings, constant);
        final ExprEvalObjectVector eval = new ExprEvalObjectVector(strings);
        return new ExprVectorProcessor<T>(){

            @Override
            public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
                return eval;
            }

            @Override
            public ExpressionType getOutputType() {
                return ExpressionType.STRING;
            }
        };
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable Double constant, int maxVectorSize) {
        boolean[] nulls;
        double[] doubles = new double[maxVectorSize];
        if (constant == null) {
            nulls = new boolean[maxVectorSize];
            Arrays.fill(nulls, true);
        } else {
            nulls = null;
            Arrays.fill(doubles, constant);
        }
        final ExprEvalDoubleVector eval = new ExprEvalDoubleVector(doubles, nulls);
        return new ExprVectorProcessor<T>(){

            @Override
            public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
                return eval;
            }

            @Override
            public ExpressionType getOutputType() {
                return ExpressionType.DOUBLE;
            }
        };
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable Long constant, int maxVectorSize) {
        boolean[] nulls;
        long[] longs = new long[maxVectorSize];
        if (constant == null) {
            nulls = new boolean[maxVectorSize];
            Arrays.fill(nulls, true);
        } else {
            nulls = null;
            Arrays.fill(longs, constant);
        }
        final ExprEvalLongVector eval = new ExprEvalLongVector(longs, nulls);
        return new ExprVectorProcessor<T>(){

            @Override
            public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
                return eval;
            }

            @Override
            public ExpressionType getOutputType() {
                return ExpressionType.LONG;
            }
        };
    }

    public static <T> ExprVectorProcessor<T> parseLong(Expr.VectorInputBindingInspector inspector, Expr arg, final int radix) {
        LongOutObjectInFunctionVectorProcessor processor = new LongOutObjectInFunctionVectorProcessor(arg.buildVectorized(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            public void processIndex(Object[] strings, long[] longs, boolean[] outputNulls, int i) {
                try {
                    String input = (String)strings[i];
                    if (input == null) {
                        longs[i] = 0L;
                        outputNulls[i] = NullHandling.sqlCompatible();
                    } else {
                        longs[i] = radix == 16 && (input.startsWith("0x") || input.startsWith("0X")) ? Long.parseLong(input.substring(2), radix) : Long.parseLong(input, radix);
                        outputNulls[i] = false;
                    }
                }
                catch (NumberFormatException e) {
                    longs[i] = 0L;
                    outputNulls[i] = NullHandling.sqlCompatible();
                }
            }
        };
        return processor;
    }

    public static <T> ExprVectorProcessor<T> isNull(Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExpressionType type = expr.getOutputType(inspector);
        if (type == null) {
            return VectorProcessors.constant(1L, inspector.getMaxVectorSize());
        }
        final long[] outputValues = new long[inspector.getMaxVectorSize()];
        ExprVectorProcessor<long[]> processor = null;
        if (Types.is(type, ExprType.STRING)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    Object[] values = (Object[])inputEval.values();
                    for (int i = 0; i < currentSize; ++i) {
                        outputValues[i] = values[i] == null ? 1L : 0L;
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        } else if (Types.is(type, ExprType.LONG)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 0L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 1L : 0L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        } else if (Types.is(type, ExprType.DOUBLE)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 0L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 1L : 0L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> isNotNull(Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExpressionType type = expr.getOutputType(inspector);
        if (type == null) {
            return VectorProcessors.constant(0L, inspector.getMaxVectorSize());
        }
        final long[] outputValues = new long[inspector.getMaxVectorSize()];
        ExprVectorProcessor<long[]> processor = null;
        if (Types.is(type, ExprType.STRING)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    Object[] values = (Object[])inputEval.values();
                    for (int i = 0; i < currentSize; ++i) {
                        outputValues[i] = values[i] == null ? 0L : 1L;
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        } else if (Types.is(type, ExprType.LONG)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 1L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 0L : 1L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        } else if (Types.is(type, ExprType.DOUBLE)) {
            final ExprVectorProcessor input = expr.buildVectorized(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 1L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 0L : 1L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }
            };
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> nvl(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        final int maxVectorSize = inspector.getMaxVectorSize();
        return VectorProcessors.makeSymmetricalProcessor(inspector, left, right, () -> new SymmetricalBivariateFunctionVectorProcessor<long[]>(ExpressionType.LONG, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(long[] leftInput, @Nullable boolean[] leftNulls, long[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (leftNulls != null && leftNulls[i]) {
                    if (rightNulls != null) {
                        this.output[i] = rightNulls[i] ? 0L : rightInput[i];
                        this.outputNulls[i] = rightNulls[i];
                    } else {
                        this.output[i] = rightInput[i];
                    }
                } else {
                    this.output[i] = leftInput[i];
                }
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new SymmetricalBivariateFunctionVectorProcessor<double[]>(ExpressionType.DOUBLE, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final double[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new double[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(double[] leftInput, @Nullable boolean[] leftNulls, double[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (leftNulls != null && leftNulls[i]) {
                    if (rightNulls != null) {
                        this.output[i] = rightNulls[i] ? 0.0 : rightInput[i];
                        this.outputNulls[i] = rightNulls[i];
                    } else {
                        this.output[i] = rightInput[i];
                    }
                } else {
                    this.output[i] = leftInput[i];
                }
            }

            @Override
            public ExprEvalVector<double[]> asEval() {
                return new ExprEvalDoubleVector(this.output, this.outputNulls);
            }
        }, () -> new SymmetricalBivariateFunctionVectorProcessor<Object[]>(ExpressionType.STRING, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final Object[] output;
            {
                super(outputType, left, right);
                this.output = new Object[maxVectorSize];
            }

            @Override
            public void processIndex(Object[] leftInput, @Nullable boolean[] leftNulls, Object[] rightInput, @Nullable boolean[] rightNulls, int i) {
                this.output[i] = leftInput[i] != null ? leftInput[i] : rightInput[i];
            }

            @Override
            public ExprEvalVector<Object[]> asEval() {
                return new ExprEvalObjectVector(this.output);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> not(Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExpressionType inputType = expr.getOutputType(inspector);
        int maxVectorSize = inspector.getMaxVectorSize();
        ExprVectorProcessor<long[]> processor = null;
        if (Types.is(inputType, ExprType.STRING)) {
            processor = new LongOutObjectInFunctionVectorProcessor(expr.buildVectorized(inspector), maxVectorSize, ExpressionType.STRING){

                @Override
                public void processIndex(Object[] strings, long[] longs, boolean[] outputNulls, int i) {
                    boolean bl = outputNulls[i] = strings[i] == null;
                    if (!outputNulls[i]) {
                        longs[i] = Evals.asLong(!Evals.asBoolean((String)strings[i]));
                    }
                }
            };
        } else if (Types.is(inputType, ExprType.LONG)) {
            processor = new LongOutLongInFunctionVectorValueProcessor(expr.buildVectorized(inspector), maxVectorSize){

                @Override
                public long apply(long input) {
                    return Evals.asLong(!Evals.asBoolean(input));
                }
            };
        } else if (Types.is(inputType, ExprType.DOUBLE)) {
            processor = !ExpressionProcessing.useStrictBooleans() ? new DoubleOutDoubleInFunctionVectorValueProcessor(expr.buildVectorized(inspector), maxVectorSize){

                @Override
                public double apply(double input) {
                    return Evals.asDouble(!Evals.asBoolean(input));
                }
            } : new LongOutDoubleInFunctionVectorValueProcessor(expr.buildVectorized(inspector), maxVectorSize){

                @Override
                public long apply(double input) {
                    return Evals.asLong(!Evals.asBoolean(input));
                }
            };
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> or(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        final int maxVectorSize = inspector.getMaxVectorSize();
        return VectorProcessors.makeSymmetricalProcessor(inspector, left, right, () -> new SymmetricalBivariateFunctionVectorProcessor<long[]>(ExpressionType.LONG, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(long[] leftInput, @Nullable boolean[] leftNulls, long[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (NullHandling.sqlCompatible()) {
                    boolean rightNull;
                    boolean leftNull = leftNulls != null && leftNulls[i];
                    boolean bl = rightNull = rightNulls != null && rightNulls[i];
                    if (leftNull) {
                        if (rightNull) {
                            this.output[i] = 0L;
                            this.outputNulls[i] = true;
                            return;
                        }
                        boolean bool = Evals.asBoolean(rightInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = !bool;
                        return;
                    }
                    if (rightNull) {
                        boolean bool = Evals.asBoolean(leftInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = !bool;
                        return;
                    }
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) || Evals.asBoolean(rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<double[], double[], long[]>(ExpressionType.LONG, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(double[] leftInput, @Nullable boolean[] leftNulls, double[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (NullHandling.sqlCompatible()) {
                    boolean rightNull;
                    boolean leftNull = leftNulls != null && leftNulls[i];
                    boolean bl = rightNull = rightNulls != null && rightNulls[i];
                    if (leftNull) {
                        if (rightNull) {
                            this.output[i] = 0L;
                            this.outputNulls[i] = true;
                            return;
                        }
                        boolean bool = Evals.asBoolean(rightInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = !bool;
                        return;
                    }
                    if (rightNull) {
                        boolean bool = Evals.asBoolean(leftInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = !bool;
                        return;
                    }
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) || Evals.asBoolean(rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<Object[], Object[], long[]>(ExpressionType.LONG, left.buildVectorized(inspector), right.buildVectorized(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(Object[] leftInput, @Nullable boolean[] leftNulls, Object[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftInput[i] == null;
                boolean bl = rightNull = rightInput[i] == null;
                if (leftNull) {
                    if (rightNull) {
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean((String)rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean((String)leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean((String)leftInput[i]) || Evals.asBoolean((String)rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> and(Expr.VectorInputBindingInspector inputTypes, Expr left, Expr right) {
        final int maxVectorSize = inputTypes.getMaxVectorSize();
        return VectorProcessors.makeSymmetricalProcessor(inputTypes, left, right, () -> new SymmetricalBivariateFunctionVectorProcessor<long[]>(ExpressionType.LONG, left.buildVectorized(inputTypes), right.buildVectorized(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(long[] leftInput, @Nullable boolean[] leftNulls, long[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (NullHandling.sqlCompatible()) {
                    boolean rightNull;
                    boolean leftNull = leftNulls != null && leftNulls[i];
                    boolean bl = rightNull = rightNulls != null && rightNulls[i];
                    if (leftNull) {
                        if (rightNull) {
                            this.output[i] = 0L;
                            this.outputNulls[i] = true;
                            return;
                        }
                        boolean bool = Evals.asBoolean(rightInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = bool;
                        return;
                    }
                    if (rightNull) {
                        boolean bool = Evals.asBoolean(leftInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = bool;
                        return;
                    }
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) && Evals.asBoolean(rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<double[], double[], long[]>(ExpressionType.DOUBLE, left.buildVectorized(inputTypes), right.buildVectorized(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(double[] leftInput, @Nullable boolean[] leftNulls, double[] rightInput, @Nullable boolean[] rightNulls, int i) {
                if (NullHandling.sqlCompatible()) {
                    boolean rightNull;
                    boolean leftNull = leftNulls != null && leftNulls[i];
                    boolean bl = rightNull = rightNulls != null && rightNulls[i];
                    if (leftNull) {
                        if (rightNull) {
                            this.output[i] = 0L;
                            this.outputNulls[i] = true;
                            return;
                        }
                        boolean bool = Evals.asBoolean(rightInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = bool;
                        return;
                    }
                    if (rightNull) {
                        boolean bool = Evals.asBoolean(leftInput[i]);
                        this.output[i] = Evals.asLong(bool);
                        this.outputNulls[i] = bool;
                        return;
                    }
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) && Evals.asBoolean(rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<Object[], Object[], long[]>(ExpressionType.STRING, left.buildVectorized(inputTypes), right.buildVectorized(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(Object[] leftInput, @Nullable boolean[] leftNulls, Object[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftInput[i] == null;
                boolean bl = rightNull = rightInput[i] == null;
                if (leftNull) {
                    if (rightNull) {
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean((String)rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean((String)leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean((String)leftInput[i]) && Evals.asBoolean((String)rightInput[i]));
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        });
    }

    private VectorProcessors() {
    }
}

