/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.lang.reflect.Array;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExpressionType;

public abstract class ExprEvalVector<T> {
    final T values;
    @Nullable
    final boolean[] nulls;

    public ExprEvalVector(T values, @Nullable boolean[] nulls) {
        this.values = values;
        this.nulls = nulls;
    }

    public T values() {
        return this.values;
    }

    @Nullable
    public Object get(int index) {
        if (this.nulls == null || NullHandling.replaceWithDefault() || !this.nulls[index]) {
            return Array.get(this.values, index);
        }
        return null;
    }

    @Nullable
    public boolean[] getNullVector() {
        return this.nulls;
    }

    public abstract ExpressionType getType();

    public abstract long[] getLongVector();

    public abstract double[] getDoubleVector();

    public abstract Object[] getObjectVector();
}

