/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalVector;

public final class ExprEvalObjectVector
extends ExprEvalVector<Object[]> {
    @Nullable
    private long[] longs;
    @Nullable
    private double[] doubles;
    @Nullable
    private boolean[] numericNulls;

    public ExprEvalObjectVector(Object[] values) {
        super(values, null);
    }

    private void computeNumbers() {
        if (this.longs == null) {
            this.longs = new long[((Object[])this.values).length];
            this.doubles = new double[((Object[])this.values).length];
            this.numericNulls = new boolean[((Object[])this.values).length];
            for (int i = 0; i < ((Object[])this.values).length; ++i) {
                Number n = ExprEval.computeNumber(Evals.asString(((Object[])this.values)[i]));
                if (n != null) {
                    this.longs[i] = n.longValue();
                    this.doubles[i] = n.doubleValue();
                    this.numericNulls[i] = false;
                    continue;
                }
                this.longs[i] = 0L;
                this.doubles[i] = 0.0;
                this.numericNulls[i] = NullHandling.sqlCompatible();
            }
        }
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        this.computeNumbers();
        return this.numericNulls;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.STRING;
    }

    @Override
    public long[] getLongVector() {
        this.computeNumbers();
        return this.longs;
    }

    @Override
    public double[] getDoubleVector() {
        this.computeNumbers();
        return this.doubles;
    }

    @Override
    public Object[] getObjectVector() {
        return (Object[])this.values;
    }
}

