/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.lang.reflect.Array;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class BivariateFunctionVectorObjectProcessor<TLeftInput, TRightInput, TOutput>
implements ExprVectorProcessor<TOutput> {
    final ExprVectorProcessor<TLeftInput> left;
    final ExprVectorProcessor<TRightInput> right;
    final int maxVectorSize;
    final TOutput outValues;
    final boolean sqlCompatible = NullHandling.sqlCompatible();

    protected BivariateFunctionVectorObjectProcessor(ExprVectorProcessor<TLeftInput> left, ExprVectorProcessor<TRightInput> right, int maxVectorSize, TOutput outValues) {
        this.left = left;
        this.right = right;
        this.maxVectorSize = maxVectorSize;
        this.outValues = outValues;
    }

    @Override
    public ExprEvalVector<TOutput> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TLeftInput> lhs = this.left.evalVector(bindings);
        ExprEvalVector<TRightInput> rhs = this.right.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        TLeftInput leftInput = lhs.values();
        TRightInput rightInput = rhs.values();
        if (this.sqlCompatible) {
            for (int i = 0; i < currentSize; ++i) {
                if (Array.get(leftInput, i) == null || Array.get(rightInput, i) == null) {
                    this.processNull(i);
                    continue;
                }
                this.processIndex(leftInput, rightInput, i);
            }
        } else {
            for (int i = 0; i < currentSize; ++i) {
                this.processIndex(leftInput, rightInput, i);
            }
        }
        return this.asEval();
    }

    abstract void processIndex(TLeftInput var1, TRightInput var2, int var3);

    abstract void processNull(int var1);

    abstract ExprEvalVector<TOutput> asEval();
}

