/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

class LambdaExpr
implements Expr {
    private final ImmutableList<IdentifierExpr> args;
    private final Expr expr;

    LambdaExpr(List<IdentifierExpr> args, Expr expr) {
        this.args = ImmutableList.copyOf(args);
        this.expr = expr;
    }

    public String toString() {
        return StringUtils.format("(%s -> %s)", this.args, this.expr);
    }

    int identifierCount() {
        return this.args.size();
    }

    @Nullable
    public String getIdentifier() {
        Preconditions.checkState((this.args.size() < 2 ? 1 : 0) != 0, (Object)"LambdaExpr has multiple arguments, use getIdentifiers");
        if (this.args.size() == 1) {
            return ((IdentifierExpr)this.args.get(0)).toString();
        }
        return null;
    }

    public List<String> getIdentifiers() {
        return this.args.stream().map(IdentifierExpr::toString).collect(Collectors.toList());
    }

    public List<String> stringifyIdentifiers() {
        return this.args.stream().map(IdentifierExpr::stringify).collect(Collectors.toList());
    }

    ImmutableList<IdentifierExpr> getIdentifierExprs() {
        return this.args;
    }

    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return this.expr.canVectorize(inspector);
    }

    @Override
    public <T> ExprVectorProcessor<T> buildVectorized(Expr.VectorInputBindingInspector inspector) {
        return this.expr.buildVectorized(inspector);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.expr.eval(bindings);
    }

    @Override
    public String stringify() {
        return StringUtils.format("(%s) -> %s", ARG_JOINER.join(this.stringifyIdentifiers()), this.expr.stringify());
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        List<IdentifierExpr> newArgs = this.args.stream().map(arg -> (IdentifierExpr)shuttle.visit((Expr)arg)).collect(Collectors.toList());
        Expr newBody = this.expr.visit(shuttle);
        return shuttle.visit(new LambdaExpr(newArgs, newBody));
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        Set<String> lambdaArgs = this.args.stream().map(IdentifierExpr::toString).collect(Collectors.toSet());
        Expr.BindingAnalysis bodyDetails = this.expr.analyzeInputs();
        return bodyDetails.removeLambdaArguments(lambdaArgs);
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.expr.getOutputType(inspector);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaExpr that = (LambdaExpr)o;
        return Objects.equals(this.args, that.args) && Objects.equals(this.expr, that.expr);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.expr);
    }
}

