/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Supplier;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

public class InputBindings {
    private static final Expr.ObjectBinding NIL_BINDINGS = new Expr.ObjectBinding(){

        @Override
        @Nullable
        public Object get(String name) {
            return null;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            return null;
        }
    };

    public static Expr.ObjectBinding nilBindings() {
        return NIL_BINDINGS;
    }

    public static Expr.InputBindingInspector inspectorFromTypeMap(final Map<String, ExpressionType> types) {
        return new Expr.InputBindingInspector(){

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return (ExpressionType)types.get(name);
            }
        };
    }

    public static Expr.ObjectBinding singleProvider(final ExpressionType type, final Function<String, ?> valueFn) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                return valueFn.apply(name);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return type;
            }
        };
    }

    public static Expr.ObjectBinding forFunction(final Function<String, ?> valueFn) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                return valueFn.apply(name);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return ExprEval.bestEffortOf(valueFn.apply(name)).type();
            }
        };
    }

    public static Expr.ObjectBinding withMap(final Map<String, ?> bindings) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                return bindings.get(name);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return ExprEval.bestEffortOf(bindings.get(name)).type();
            }
        };
    }

    public static Expr.ObjectBinding withTypedSuppliers(final Map<String, Pair<ExpressionType, Supplier<Object>>> bindings) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                Pair binding = (Pair)bindings.get(name);
                return binding == null || binding.rhs == null ? null : ((Supplier)binding.rhs).get();
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                Pair binding = (Pair)bindings.get(name);
                if (binding == null) {
                    return null;
                }
                return (ExpressionType)binding.lhs;
            }
        };
    }
}

