/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.IdentifierVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

class IdentifierExpr
implements Expr {
    final String identifier;
    final String binding;

    IdentifierExpr(String value) {
        this.identifier = value;
        this.binding = value;
    }

    IdentifierExpr(String identifier, String binding) {
        this.identifier = identifier;
        this.binding = binding;
    }

    public String toString() {
        return this.binding;
    }

    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getBinding() {
        return this.binding;
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    @Override
    @Nullable
    public String getIdentifierIfIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getBindingIfIdentifier() {
        return this.binding;
    }

    @Override
    @Nullable
    public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return this;
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return new Expr.BindingAnalysis(this);
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return inspector.getType(this.binding);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofType(bindings.getType(this.binding), bindings.get(this.binding));
    }

    @Override
    public String stringify() {
        return StringUtils.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.binding));
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return true;
    }

    public ExprVectorProcessor<?> buildVectorized(Expr.VectorInputBindingInspector inspector) {
        ExpressionType inputType = inspector.getType(this.binding);
        if (inputType == null) {
            return new IdentifierVectorProcessor<Object[]>(ExpressionType.STRING){

                @Override
                public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
                    return new ExprEvalObjectVector(bindings.getObjectVector(IdentifierExpr.this.binding));
                }
            };
        }
        switch ((ExprType)inputType.getType()) {
            case LONG: {
                return new IdentifierVectorProcessor<long[]>(inputType){

                    @Override
                    public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                        return new ExprEvalLongVector(bindings.getLongVector(IdentifierExpr.this.binding), bindings.getNullVector(IdentifierExpr.this.binding));
                    }
                };
            }
            case DOUBLE: {
                return new IdentifierVectorProcessor<double[]>(inputType){

                    @Override
                    public ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
                        return new ExprEvalDoubleVector(bindings.getDoubleVector(IdentifierExpr.this.binding), bindings.getNullVector(IdentifierExpr.this.binding));
                    }
                };
            }
            case STRING: {
                return new IdentifierVectorProcessor<Object[]>(inputType){

                    @Override
                    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
                        return new ExprEvalObjectVector(bindings.getObjectVector(IdentifierExpr.this.binding));
                    }
                };
            }
        }
        throw Exprs.cannotVectorize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierExpr that = (IdentifierExpr)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

