/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.segment.column.Types;

public class ExpressionTypeConversion {
    public static ExpressionType conditional(Expr.InputBindingInspector inspector, List<Expr> args) {
        ExpressionType type = null;
        for (Expr arg : args) {
            if (type == null) {
                type = arg.getOutputType(inspector);
                continue;
            }
            type = ExpressionTypeConversion.function(type, arg.getOutputType(inspector));
        }
        return type;
    }

    public static ExpressionType autoDetect(ExprEval eval, ExprEval otherEval) {
        ExpressionType type = eval.type();
        ExpressionType otherType = otherEval.type();
        if (Types.is(type, ExprType.STRING) && Types.is(otherType, ExprType.STRING)) {
            return ExpressionType.STRING;
        }
        type = eval.value() != null ? type : otherType;
        otherType = otherEval.value() != null ? otherType : type;
        return ExpressionTypeConversion.numeric(type, otherType);
    }

    @Nullable
    public static ExpressionType operator(@Nullable ExpressionType type, @Nullable ExpressionType other) {
        if (type == null) {
            return other;
        }
        if (other == null) {
            return type;
        }
        if (type.isArray() || other.isArray()) {
            if (!Objects.equals(type, other)) {
                throw new IAE("Cannot implicitly cast %s to %s", type, other);
            }
            return type;
        }
        if (type.is(ExprType.COMPLEX) || other.is(ExprType.COMPLEX)) {
            if (type.getElementType() == null) {
                return other;
            }
            if (other.getElementType() == null) {
                return type;
            }
            if (!Objects.equals(type, other)) {
                throw new IAE("Cannot implicitly cast %s to %s", type, other);
            }
            return type;
        }
        if (type.is(ExprType.STRING) && other.is(ExprType.STRING)) {
            return ExpressionType.STRING;
        }
        return ExpressionTypeConversion.numeric(type, other);
    }

    @Nullable
    public static ExpressionType function(@Nullable ExpressionType type, @Nullable ExpressionType other) {
        if (type == null) {
            return other;
        }
        if (other == null) {
            return type;
        }
        if (type.isArray() || other.isArray()) {
            if (!Objects.equals(type, other)) {
                throw new IAE("Cannot implicitly cast %s to %s", type, other);
            }
            return type;
        }
        if (type.is(ExprType.COMPLEX) || other.is(ExprType.COMPLEX)) {
            if (type.getComplexTypeName() == null) {
                return other;
            }
            if (other.getComplexTypeName() == null) {
                return type;
            }
            if (!Objects.equals(type, other)) {
                throw new IAE("Cannot implicitly cast %s to %s", type, other);
            }
            return type;
        }
        if (Types.is(type, ExprType.STRING) || Types.is(other, ExprType.STRING)) {
            return ExpressionType.STRING;
        }
        return ExpressionTypeConversion.numeric(type, other);
    }

    @Nullable
    public static ExpressionType coerceArrayTypes(@Nullable ExpressionType type, @Nullable ExpressionType other) {
        ExpressionType otherArrayType;
        if (type == null) {
            return other;
        }
        if (other == null) {
            return type;
        }
        if (Objects.equals(type, other)) {
            return type;
        }
        ExpressionType typeArrayType = type.isArray() ? type : ExpressionTypeFactory.getInstance().ofArray(type);
        ExpressionType expressionType = otherArrayType = other.isArray() ? other : ExpressionTypeFactory.getInstance().ofArray(other);
        if (typeArrayType.getElementType().isPrimitive() && otherArrayType.getElementType().isPrimitive()) {
            ExpressionType newElementType = ExpressionTypeConversion.function((ExpressionType)typeArrayType.getElementType(), (ExpressionType)otherArrayType.getElementType());
            return ExpressionTypeFactory.getInstance().ofArray(newElementType);
        }
        throw new IAE("Cannot implicitly cast %s to %s", type, other);
    }

    @Nullable
    public static ExpressionType integerMathFunction(@Nullable ExpressionType type, @Nullable ExpressionType other) {
        ExpressionType functionType = ExpressionTypeConversion.function(type, other);
        return functionType != null && functionType.isNumeric() ? ExpressionType.LONG : functionType;
    }

    public static ExpressionType numeric(@Nullable ExpressionType type, @Nullable ExpressionType other) {
        if (Types.is(type, ExprType.LONG) && Types.isNullOr(other, ExprType.LONG)) {
            return ExpressionType.LONG;
        }
        return ExpressionType.DOUBLE;
    }

    private ExpressionTypeConversion() {
    }
}

