/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExpressionProcessingConfig;

public class ExpressionProcessing {
    @Inject
    private static ExpressionProcessingConfig INSTANCE;

    @VisibleForTesting
    public static void initializeForTests(@Nullable Boolean allowNestedArrays) {
        INSTANCE = new ExpressionProcessingConfig(allowNestedArrays, null, null, null);
    }

    @VisibleForTesting
    public static void initializeForStrictBooleansTests(boolean useStrict) {
        INSTANCE = new ExpressionProcessingConfig(null, useStrict, null, null);
    }

    @VisibleForTesting
    public static void initializeForHomogenizeNullMultiValueStrings() {
        INSTANCE = new ExpressionProcessingConfig(null, null, null, true);
    }

    public static boolean allowNestedArrays() {
        ExpressionProcessing.checkInitialized();
        return INSTANCE.allowNestedArrays();
    }

    public static boolean useStrictBooleans() {
        ExpressionProcessing.checkInitialized();
        return INSTANCE.isUseStrictBooleans();
    }

    public static boolean processArraysAsMultiValueStrings() {
        ExpressionProcessing.checkInitialized();
        return INSTANCE.processArraysAsMultiValueStrings();
    }

    public static boolean isHomogenizeNullMultiValueStringArrays() {
        ExpressionProcessing.checkInitialized();
        return INSTANCE.isHomogenizeNullMultiValueStringArrays();
    }

    private static void checkInitialized() {
        if (INSTANCE == null) {
            throw new IllegalStateException("ExpressionProcessing module not initialized, call ExpressionProcessing.initializeForTests() or one of its variants");
        }
    }
}

